####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - file_paths.R
##### - make_RNAseq.R
####################################################################

source('00_library_of_functions.R')
library(compEpiTools)
load(file=file.path('data','ChIPseq_data.RData'))

load(
	# inputBamFile,mycChIPbamfiles,pol2ChIPbamfiles,
	# mycPeaksfiles,pol2Peaksfiles,pol2BroadPeaksfiles,
	# bampaths_4su_rep1,bampaths_4su_rep2,bampaths_4su_rep3,
	# bampaths_total_rep1,bampaths_total_rep2,bampaths_total_rep3,
	file=file.path('data','paths_3T9_mycER.RData')
	)

library(TxDb.Mmusculus.UCSC.mm9.knownGene)
require(org.Mm.eg.db)
symb2eg <- as.list(org.Mm.egSYMBOL2EG)

rpkmsAndCounts_rep1 <- readRDS(file=file.path('data','3T9MycER_rpkmsAndCounts_rep1.rds'))
rpkmsAndCounts_rep2 <- readRDS(file=file.path('data','3T9MycER_rpkmsAndCounts_rep2.rds'))
rpkmsAndCounts_rep3 <- readRDS(file=file.path('data','3T9MycER_rpkmsAndCounts_rep3.rds'))

normfact1 <- unname(colSums(rpkmsAndCounts_rep1$counts$foursu$stat[2:3,c(1:4,7:8)]))
normfact2 <- unname(colSums(rpkmsAndCounts_rep2$counts$foursu$stat[2:3,c(1:4,7:8)]))
normfact3 <- unname(colSums(rpkmsAndCounts_rep3$counts$foursu$stat[2:3,c(1:4,7:8)]))

# annotation

txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene
exonsDB <- reduce(exonsBy(txdb ,'gene'))
exonsDB <- exonsDB[elementNROWS(range(exonsDB))==1]
intronsDB <- psetdiff(unlist(range(exonsDB)),exonsDB)
intronsDB <- intronsDB[elementNROWS(intronsDB)>0]

# up genes 

geneSymb <- c('Mthfd1l','Ddx10','Eml4','Bcar3', 'Ctnna1')
geneEID <- unlist(symb2eg[geneSymb])

l2fcMat <- lapply(geneEID, function(eg) {

	intronsAnn <- intronsDB[[eg]]
	if( as.character(strand(intronsAnn)[1]) ==  '+' ) intronsAnn <- rev(intronsAnn)

	readsLabeled_rep1 <- unname(sapply(bampaths_4su_rep1[c(1:4,7:8)], function(file)
			GRcoverage(intronsAnn, file, Nnorm=FALSE, Snorm=FALSE)))
	nreadsLabeled_rep1 <- t(t(readsLabeled_rep1)/normfact1)
	fcLabeled_rep1 <- log2(nreadsLabeled_rep1[,-1]) - log2(nreadsLabeled_rep1[,1])

	readsLabeled_rep2 <- unname(sapply(bampaths_4su_rep2[c(1:4,7:8)], function(file)
			GRcoverage(intronsAnn, file, Nnorm=FALSE, Snorm=FALSE)))
	nreadsLabeled_rep2 <- t(t(readsLabeled_rep2)/normfact2)
	fcLabeled_rep2 <- log2(nreadsLabeled_rep2[,-1]) - log2(nreadsLabeled_rep2[,1])

	readsLabeled_rep3 <- unname(sapply(bampaths_4su_rep3[c(1:4,7:8)], function(file)
			GRcoverage(intronsAnn, file, Nnorm=FALSE, Snorm=FALSE)))
	nreadsLabeled_rep3 <- t(t(readsLabeled_rep3)/normfact3)
	fcLabeled_rep3 <- log2(nreadsLabeled_rep3[,-1]) - log2(nreadsLabeled_rep3[,1])

	fcLabeled <- apply(array(cbind(fcLabeled_rep1, fcLabeled_rep2, fcLabeled_rep3), 
		dim=c(nrow(fcLabeled_rep1), ncol(fcLabeled_rep1), 2)), 1:2, mean)

	readsPol2input <- GRcoverage(intronsAnn, inputBamFile, Nnorm=FALSE, Snorm=FALSE)
	readsPol2 <- unname(sapply(pol2ChIPbamfiles, function(file)
		GRcoverage(intronsAnn, file, Nnorm=FALSE, Snorm=FALSE)))
	nreadsPol2 <- t(t(readsPol2 - sapply(inputPol2Scales, function(x) readsPol2input * x))/pol2SampleNorm)
	nreadsPol2[nreadsPol2<0] <- NA #min(nreadsPol2[nreadsPol2>0])
	fcPol2 <- log2(nreadsPol2[,-1]) - log2(nreadsPol2[,1])

	list(lab=fcLabeled, pol=fcPol2)

	})

save(l2fcMat, file=file.path('data', 'elongation_tx.RData'))

