#########################
###### Mus Musculus ########
#########################

require(org.Mm.eg.db)
symb2egMM <- as.list(org.Mm.egSYMBOL2EG)

## EuMyc

rnaseq <- read.table(file.path('..','tables','EuMyc_RNAseq.xls'), 
	header=TRUE, stringsAsFactors=FALSE)
eids <- symb2egMM[rnaseq$Gene.Symbol]
eids[sapply(eids,is.null)] <- NA
eids <- unlist(sapply(eids,'[[',1))
rnaseq$EntrezID <- eids
filt <- with(rnaseq, ! ( is.na(EntrezID) | is.na(log2.T1.C.) | is.na(qvalue.T1vsC) ))
rnaseqfilt <- rnaseq[filt,]

eumycRNA <- data.frame(
	EntrezID=rnaseqfilt$EntrezID,
	log2ratio=rnaseqfilt$'log2.T1.C.',
	qvalue=rnaseqfilt$'qvalue.T1vsC',
	stringsAsFactors=FALSE
	)

## mycER

library(DESeq2)
load(file=file.path('..','data','3T9MycER_DESeq2.RData'))
tCEres <- results(tCE, contrast=c("tpts","4","0"))
mycerRNA <- data.frame(
	EntrezID=rownames(tCEres),
	log2ratio=tCEres$log2FoldChange,
	qvalue=tCEres$padj,
	stringsAsFactors=FALSE
	)

## TetMyc

rnaseq <- read.table(file.path('..','tables','liver_tetMyc_RNAseq.xls'), 
	header=T, stringsAsFactors=FALSE)
eids <- symb2egMM[rnaseq$genes]
eids[sapply(eids,is.null)] <- NA
eids <- unlist(sapply(eids,'[[',1))
rnaseq$entrez_id <- eids
rnaseq$TvsC_log2FC[!is.finite(rnaseq$TvsC_log2FC)] <- NA
rnaseq <- na.omit(rnaseq)

tetmycRNA <- data.frame(
	EntrezID=rnaseq$entrez_id,
	log2ratio=rnaseq$'TvsC_log2FC',
	qvalue=rnaseq$'TvsC_padj',
	stringsAsFactors=FALSE
	)

TetmycDepEIDs <- with(rnaseq, entrez_id[Myc_dep_UP=='yes'|Myc_dep_DN=='yes'])
TetmycIndEIDs <- with(rnaseq, entrez_id[Myc_indep_UP=='yes'|Myc_indep_DN=='yes'])
save(TetmycDepEIDs, TetmycIndEIDs, file=file.path('..','data','TetmycDepIndepEIDs.RData'))

#########################
###### Homo Sapiens #######
#########################

require(org.Hs.eg.db)
symb2egHS <- as.list(org.Hs.egSYMBOL2EG)

## p493 ( Young )

rnaseq <- read.table(file.path('..','tables','p493_RNAseq.xls'), 
	header=T, stringsAsFactors=FALSE)
rnaseq$Gene <- rownames(rnaseq)
eids <- symb2egHS[rnaseq$Gene]
eids[sapply(eids,is.null)] <- NA
eids <- unlist(sapply(eids,'[[',1))
rnaseq$entrez_id <- eids
rnaseq$rnaFC <- with(rnaseq, log2(GSM1001394_High_cMyc_P493/GSM1001393_Low_cMyc_P493))
rnaseq$rnaFC[!is.finite(rnaseq$rnaFC)] <- NA
rnaseq <- na.omit(rnaseq)
rnaseq$padj <- 0

p493RNA <- data.frame(
	EntrezID=rnaseq$entrez_id,
	log2ratio=rnaseq$rnaFC,
	qvalue=rnaseq$padj,
	stringsAsFactors=FALSE
	)

## Waltz2014

rnaseq <- read.table(file.path('..','tables','u2os_RNAseq.xls'), 
	header=TRUE, stringsAsFactors=FALSE)
eids <- symb2egHS[rnaseq$hgnc_symbol]
eids[sapply(eids,is.null)] <- NA
eids <- unlist(sapply(eids,'[[',1))
rnaseq$entrez_id <- eids
filt <- with(rnaseq, ! ( is.na(entrez_id) | is.na(logFC) | is.na(padj) ))
rnaseqfilt <- rnaseq[filt,]

Waltz2014RNA <- data.frame(
	EntrezID=rnaseqfilt$entrez_id,
	log2ratio=rnaseqfilt$logFC,
	qvalue=rnaseqfilt$padj,
	stringsAsFactors=FALSE
	)

############
## save ######
############

allsysRNA <- list(
	EuMyc=eumycRNA,
	MycER=mycerRNA,
	TetMyc=tetmycRNA,
	p493=p493RNA,
	Waltz2014=Waltz2014RNA
	)

save(allsysRNA, file=file.path('..','data','allsysRNA.RData'))




