####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - make_RNAPII_modeling.R
####################################################################

source('00_library_of_functions.R')
load(
	# pol2modelingfeatures, pol2modelingclust, 
	file=file.path('..','data','pol2modelingclustering.RData'))

## time (and its logarithm transformations)

tpts <- c(0,1/6,1/3,1/2,2,4)
tptsfine <- seq(min(tpts),max(tpts),length.out=400)
log_shift <- find_tt_par(tpts)
tptslog <- time_transf(tpts, log_shift)
tptsfine <- 2^seq(min(tptslog),max(tptslog),length.out=400) - log_shift

## load modeling results

clIdx <- which(pol2modelingclust$kmeans$size>50)

seeds <- 1:10; names(seeds) <- seeds
clusters <- seq_along(clIdx); names(clusters) <- clusters
allmodels <- sapply(seeds, function(i) lapply(clusters, function(j) {
	readRDS(paste0("data/pol2modeling/seed_",i,"/cluster_",j,"_optim_rates_constr.rds"))
	}))

## select best models

exampleModel <- readRDS(paste0("data/pol2modeling/seed_1/cluster_1_optim_rates_constr.rds"))
models <- seq_along(exampleModel)
names(models) <- names(exampleModel)
positiverates <- lapply(models, function(k) sapply(seeds, function(i) sapply(clusters, function(j) 
	all(sapply(allmodels[[j,i]][[k]][2:4], function(x) evalModel(tptsfine,x))>0)
	)))
explainedvar <- lapply(models, function(k) sapply(seeds, function(i) sapply(clusters, function(j) 
	(allmodels[[j,i]][[1]]$value-allmodels[[j,i]][[k]]$value)/allmodels[[j,i]][[1]]$value
	)))
chosen_seeds <- sapply(models, function(k) sapply(clusters, function(i) {
	ev <- explainedvar[[k]][i,]
	names(ev) <- seq_along(ev)
	as.numeric(names(which.max(ev[positiverates[[k]][i,]])))
	}))
chosen_models <- t(sapply(allmodels[,2], function(x) 
	x[c('KKKK','IKKK','KIKK','KKIK','KKKI','IIII')]))
null_models <- chosen_models[,'KKKK']
singlevar_models <- chosen_models[,c('IKKK','KIKK','KKIK','KKKI')]
optimized_models <- chosen_models[,'IIII']

## extract rates and order clusters

fluxes <- sapply(optimized_models, function(x) evalModel(tptsfine, x[[1]]))
relfluxes <- t(t(log2(fluxes))-log2(fluxes[1,]))
relfluxesNeg <- t(t(log2(-fluxes)))

firings <- sapply(optimized_models, function(x) evalModel(tptsfine, x[[2]]))
relfirings <- t(t(log2(firings))-log2(firings[1,]))

elongations <- sapply(optimized_models, function(x) evalModel(tptsfine, x[[3]]))
relelongations <- t(t(log2(elongations))-log2(elongations[1,]))

releases <- sapply(optimized_models, function(x) evalModel(tptsfine, x[[4]]))
relreleases <- t(t(log2(releases))-log2(releases[1,]))

# relrates <- t(rbind(relfluxes,relfirings,relelongations,relreleases))
# ordRows <- hclust(corDist(relrates, use='p'))$ord

ordRows <- c(7, 1, 2, 12, 9, 8, 5, 3, 10, 11, 6, 4)
names(ordRows) <- seq_along(ordRows)
save(ordRows, file='data/ordRows.rds')

save(
	tpts,tptsfine,tptslog,tptsfine,
	null_models, singlevar_models, optimized_models, 
	fluxes, relfluxes, relfluxesNeg, firings, relfirings, elongations, relelongations, 
	releases, relreleases, ordRows, 
	file=file.path('..','data','RNAPII_modeling_elaborated.RData')
	)





