####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - gather_and_filter.R
####################################################################

n <- as.numeric(commandArgs(trailingOnly=TRUE)[1])

library(parallel)
source('00_library_of_functions.R')
load(file.path('..','data',paste0('bootstraps_tranches.rds')))
tpts <- c(0,1/6,1/3,1/2,2,4)

trainingSetModels <- mclapply(trainingSets[[n]], function(pseudogene) {
	print('started')
	out <- rnapii_model(tpts, pseudogene, model_type='IIII', seed=1, constrained=TRUE)
	print('terminated')
	return(out)
	}, mc.cores=detectCores())

save(trainingSetModels, 
	file=file.path('..','data',paste0('trainingSetModels',n,'.rds')))

