####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - gather_and_filter.R
####################################################################

seed <- as.numeric(commandArgs(trailingOnly=TRUE)[1])

library(parallel)
source('00_library_of_functions.R')
pseudogenes <- readRDS(file.path('..','data','pseudogenes.rds'))

####################################
############## RNAPII modeling ############
########################################

tpts <- c(0,1/6,1/3,1/2,2,4)
dir.create(file.path('..',"data","pol2modeling",paste0("seed_",seed)), 
	recursive=TRUE, showWarnings=FALSE)
tonull <- mclapply(seq_along(pseudogenes), function(i) {

	# message("################")
	# message("cluster ",i)
	# message("################")

	# models_to_test <- apply(expand.grid(rep(list(c('K','S','I')), 4)),1,
	# 	paste,collapse='')
	models_to_test <- c('KKKK','IKKK','KIKK','KKIK','KKKI','IIII')
	names(models_to_test) <- models_to_test
	optimized_models <- lapply(models_to_test, function(mtt)
		tryCatch({
			message('Cluster ',i,' model ', mtt, ' started at\t',date())
			t <- system.time(
				out <- rnapii_model(tpts, pseudogenes[[i]], 
					model_type=mtt, seed=seed, constrained=TRUE)
				)
			message('Cluster ',i,' model ', mtt, ' finished in\t',t[3],'\tseconds.')
			return(out)
		}, error=function(e) e)
		)

	saveRDS(optimized_models, 
		file=file.path('..',
			"data","pol2modeling",
			paste0("seed_",seed),
			paste0("cluster_",i,"_optim_rates_constr.rds")
			))

	}, mc.cores=detectCores())

