####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - file_paths.R
####################################################################

source('00_library_of_functions.R')

load(file=file.path('..','data','paths_3T9_mycER.RData'))
load(file.path('..','data','paths_myc_binding_external_data.RData'))

### TSS granges

library(TxDb.Mmusculus.UCSC.mm9.knownGene)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)

## MycER

print('MycER')

MycER <- makeChIPdata(
	peaks = bedfiles2granges(mycPeaksfiles[c(1,6)]) , 
	BAM = list(mycChIPbamfiles[1],mycChIPbamfiles[6]),
	txdb = TxDb.Mmusculus.UCSC.mm9.knownGene
	)

## p493

print('p493')

p493 <- makeChIPdata(
	peaks = bedfiles2granges(GSE36354peaksfiles) , 
	BAM = list(low=GSE36354bamfiles[1], high=GSE36354bamfiles[2]),
	txdb = TxDb.Hsapiens.UCSC.hg19.knownGene
	)

## Waltz2014

print('Waltz2014')

Waltz2014 <- makeChIPdata(
	peaks = bedfiles2granges(GSE44672peaksfiles) , 
	BAM = list(low=GSE44672bamfiles[1], high=GSE44672bamfiles[2]),
	txdb = TxDb.Hsapiens.UCSC.hg19.knownGene
	)

## EuMycCT1

print('EuMycCT1')

EuMycCT1 <- makeChIPdata(
	peaks = bedfiles2granges(GSE51011peaksfiles) , 
	BAM = list(low=GSE51011bamfiles[1], high=GSE51011bamfiles[2]),
	txdb = TxDb.Mmusculus.UCSC.mm9.knownGene
	)

## TetMyc

print('TetMyc')

TetMyc <- makeChIPdata(
	peaks = bedfiles2granges(GSE76042peaksfiles) , 
	BAM = list(low=GSE76042bamfiles[1], high=GSE76042bamfiles[2]),
	txdb = TxDb.Mmusculus.UCSC.mm9.knownGene
	)

### save data

allMycChIP <- list(
	MycER = MycER,
	p493 = p493,
	Waltz2014 = Waltz2014,
	EuMyc = EuMycCT1,
	TetMyc = TetMyc
	)

save(allMycChIP, file=file.path('..','data','allMycChIP.RData'))





