####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - file_paths.R
####################################################################

source('00_library_of_functions.R')

load(file=file.path('..','data','paths_miz_binding.RData'))

# miz1GSE44672peaksfiles, miz1GSE44672bamfiles, miz1GSE51011peaksfiles,
# miz1GSE51011bamfiles, miz1Peaksfiles, miz1ChIPbamfiles,

### TSS granges

library(TxDb.Mmusculus.UCSC.mm9.knownGene)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)

## MycER

print('MycER')

MycER <- makeChIPdata(
	peaks = bedfiles2granges(miz1Peaksfiles) , 
	BAM = list(miz1ChIPbamfiles[1],miz1ChIPbamfiles[2]),
	txdb = TxDb.Mmusculus.UCSC.mm9.knownGene
	)

## Waltz2014

print('Waltz2014')

Waltz2014 <- makeChIPdata(
	peaks = bedfiles2granges(miz1GSE44672peaksfiles) , 
	BAM = list(low=miz1GSE44672bamfiles[1], high=miz1GSE44672bamfiles[2]),
	txdb = TxDb.Hsapiens.UCSC.hg19.knownGene
	)

## EuMycCT1

print('EuMycCT1')

EuMycCT1 <- makeChIPdata(
	peaks = bedfiles2granges(miz1GSE51011peaksfiles) , 
	BAM = list(low=miz1GSE51011bamfiles[1], high=miz1GSE51011bamfiles[2]),
	txdb = TxDb.Mmusculus.UCSC.mm9.knownGene
	)

### save data

allMiz1ChIP <- list(
	MycER = MycER,
	Waltz2014 = Waltz2014,
	EuMyc = EuMycCT1
	)

save(allMiz1ChIP, file=file.path('..','data','allMiz1ChIP.RData'))





