####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - make_INSPEcT_smoothrates.R
####################################################################

library(devtools)
load_all('INSPEcT')

# combine splitted datasets

load(file=file.path('..','data','mycerIds_group_1.RData'))
mycerIds <- mycerIds_group
for(i in 2:20) {
	load(file=file.path('..','data',paste0('mycerIds_group_',i,'.RData')))
	mycerIds <- combine(mycerIds, mycerIds_group)
}
save(mycerIds, file=file.path('..',"data","3T9MycER_INSPEcTdataset.RData"))

total <- viewModelRates(mycerIds, 'total')
preMRNA <- viewModelRates(mycerIds, 'preMRNA')

synthesis <- viewModelRates(mycerIds, 'synthesis')
processing <- viewModelRates(mycerIds, 'processing')
degradation <- viewModelRates(mycerIds, 'degradation')

save(total,preMRNA,synthesis,processing,degradation,
	file=file.path('..','data','3T9MycER_smooth_rates.RData'))

