####################################################################
##### DEPENDS ON THE PREVIOUS EXECUTION OF THE FOLLOWING SCRIPTS:
##### - make_RNAseq.R
####################################################################

library(DESeq2)

rpkmsAndCounts_rep1 <- readRDS(
	file=file.path('..','data','3T9MycER_rpkmsAndCounts_rep1.rds'))
rpkmsAndCounts_rep2 <- readRDS(
	file=file.path('..','data','3T9MycER_rpkmsAndCounts_rep2.rds'))
rpkmsAndCounts_rep3 <- readRDS(
	file=file.path('..','data','3T9MycER_rpkmsAndCounts_rep3.rds'))

tcA_total_exons <- rpkmsAndCounts_rep1$counts$total$exonCounts
tcB_total_exons <- rpkmsAndCounts_rep2$counts$total$exonCounts
tcC_total_exons <- rpkmsAndCounts_rep3$counts$total$exonCounts

totalGenesExons <- cbind(
	tcA_total_exons
	, tcB_total_exons
	, tcC_total_exons
	)

tpts <- c(0,1/6,1/3,1/2,1,1.5,2,4,8,12,16)
x <- as.factor(rep(round(tpts,2), times=3))

tCE <- DESeq(DESeqDataSetFromMatrix(
        countData=totalGenesExons,
        colData=DataFrame(tpts=factor(rep(signif(tpts,2),3))),
        design=~tpts
        ))

tCEres <- lapply(round(tpts[-1],2), function(x)
	results(tCE, contrast=c("tpts",x,"0")))

baseMeans <- sapply(tCEres, '[[', 'baseMean')
log2ratios <-  sapply(tCEres, '[[', 'log2FoldChange')
pvalues <- sapply(tCEres, '[[', 'pvalue')
qvalues <- sapply(tCEres, '[[', 'padj')

colnames(baseMeans) <- colnames(log2ratios) <- 
	colnames(pvalues) <- colnames(qvalues) <- round(tpts[-1],2)
rownames(baseMeans) <- rownames(log2ratios) <- 
	rownames(pvalues) <- rownames(qvalues) <- names(tCE)

save(tCE, tCEres, baseMeans, log2ratios,
	pvalues, qvalues,file=file.path('..','data','3T9MycER_DESeq2.RData'))
