########################
## 3T9 mycER files #########
########################

inputBamFile <- "GSM2595123.bam"

mycChIPbamfiles <- c(
	"0min"="GSM2595124.bam",
	"10min"="GSM2595125.bam",
	"20min"="GSM2595126.bam",
	"30min"="GSM2595127.bam",
	"2h"="GSM2595128.bam",
	"4h"="GSM2595129.bam"
)

pol2ChIPbamfiles <- c(
	"0min"="GSM2595130.bam",
	"10min"="GSM2595131.bam",
	"20min"="GSM2595132.bam",
	"30min"="GSM2595133.bam",
	"2h"="GSM2595134.bam",
	"4h"="GSM2595135.bam"
)

mycPeaksfiles <- c(
	"GSM2595124_peaks.xls",
	"GSM2595125_peaks.xls",
	"GSM2595126_peaks.xls",
	"GSM2595127_peaks.xls",
	"GSM2595128_peaks.xls",
	"GSM2595129_peaks.xls"
	)

pol2Peaksfiles <- c(
	"GSM2595130_peaks.xls",
	"GSM2595131_peaks.xls",
	"GSM2595132_peaks.xls",
	"GSM2595133_peaks.xls",
	"GSM2595134_peaks.xls",
	"GSM2595135_peaks.xls"
	)

pol2BroadPeaksfiles <- c(
	"GSM2595130_broadpeaks.xls",
	"GSM2595131_broadpeaks.xls",
	"GSM2595132_broadpeaks.xls",
	"GSM2595133_broadpeaks.xls",
	"GSM2595134_broadpeaks.xls",
	"GSM2595135_broadpeaks.xls"
	)

bampaths_4su_rep1 <- c(
	"GSM2595057.bam",
	"GSM2595058.bam",
	"GSM2595059.bam",
	"GSM2595060.bam",
	"GSM2595061.bam",
	"GSM2595062.bam",
	"GSM2595063.bam",
	"GSM2595064.bam",
	"GSM2595065.bam",
	"GSM2595066.bam",
	"GSM2595067.bam"
	)

bampaths_4su_rep2 <- c(
	"GSM2595079.bam",
	"GSM2595080.bam",
	"GSM2595081.bam",
	"GSM2595082.bam",
	"GSM2595083.bam",
	"GSM2595084.bam",
	"GSM2595085.bam",
	"GSM2595086.bam",
	"GSM2595087.bam",
	"GSM2595088.bam",
	"GSM2595089.bam"
	)

bampaths_4su_rep3 <- c(
	"GSM2595101.bam",
	"GSM2595102.bam",
	"GSM2595103.bam",
	"GSM2595104.bam",
	"GSM2595105.bam",
	"GSM2595106.bam",
	"GSM2595107.bam",
	"GSM2595108.bam",
	"GSM2595109.bam",
	"GSM2595110.bam",
	"GSM2595111.bam"
	)

bampaths_total_rep1 <- c(
	"GSM2595068.bam",
	"GSM2595069.bam",
	"GSM2595070.bam",
	"GSM2595071.bam",
	"GSM2595072.bam",
	"GSM2595073.bam",
	"GSM2595074.bam",
	"GSM2595075.bam",
	"GSM2595076.bam",
	"GSM2595077.bam",
	"GSM2595078.bam"
	)

bampaths_total_rep2 <- c(
	"GSM2595090.bam",
	"GSM2595091.bam",
	"GSM2595092.bam",
	"GSM2595093.bam",
	"GSM2595094.bam",
	"GSM2595095.bam",
	"GSM2595096.bam",
	"GSM2595097.bam",
	"GSM2595098.bam",
	"GSM2595099.bam",
	"GSM2595100.bam"
	)

bampaths_total_rep3 <- c(
	"GSM2595112.bam",
	"GSM2595113.bam",
	"GSM2595114.bam",
	"GSM2595115.bam",
	"GSM2595116.bam",
	"GSM2595117.bam",
	"GSM2595118.bam",
	"GSM2595119.bam",
	"GSM2595120.bam",
	"GSM2595121.bam",
	"GSM2595122.bam"
	)

save(
	inputBamFile,mycChIPbamfiles,pol2ChIPbamfiles,
	mycPeaksfiles,pol2Peaksfiles,pol2BroadPeaksfiles,
	bampaths_4su_rep1,bampaths_4su_rep2,bampaths_4su_rep3,
	bampaths_total_rep1,bampaths_total_rep2,bampaths_total_rep3,
	file=file.path('..','data','paths_3T9_mycER.RData')
	)

##################################
## Myc binding external data #########
#################################

GSE36354peaksfiles <- c(
	'GSM894059_peaks.xls',
	'GSM894058_peaks.xls'
	)
GSE36354bamfiles <- c(
	'GSM894059.bam',
	'GSM894058.bam'
	)

GSE44672peaksfiles <- c(
	"GSM1231598_peaks.xls",
	"GSM1231597_peaks.xls"
	)
GSE44672bamfiles <- c(
	"GSM1231598.bam",
	"GSM1231597.bam"
	)

GSE51011peaksfiles <- c(
	'GSM1234471_peaks.xls',
	'GSM1234475_peaks.xls'
	)
GSE51011bamfiles <- c(
	'GSM1234471.bam',
	'GSM1234475.bam'
	)

GSE76042peaksfiles <- c(
	'GSM1973347_peaks.xls',
	'GSM1973351_peaks.xls'
	)
GSE76042bamfiles <- c(
	'GSM1973347.bam',
	'GSM1973351.bam'
	)

save(
	GSE36354peaksfiles,GSE36354bamfiles,
	GSE44672peaksfiles,GSE44672bamfiles,
	GSE51011peaksfiles,GSE51011bamfiles,
	GSE76042peaksfiles,GSE76042bamfiles,
	file=file.path('..','data','paths_myc_binding_external_data.RData')
	)

############################
## Miz1 binding (all) #########
##########################

## u20s

miz1GSE44672peaksfiles <- c(
	"GSM1231600_peaks.xls",
	"GSM1231599_peaks.xls"
	)
miz1GSE44672bamfiles <- c(
	"GSM1231600.bam",
	"GSM1231599.bam"
	)

## Eu-Myc

miz1GSE51011peaksfiles <- c(
	'EuMyc.T27_Miz10E2_peaks_peaks.xls',
	'EuMyc.S_10E2_C_peaks_peaks.xls'
	)
miz1GSE51011bamfiles <- c(
	'/data/BA/public_html/HTS-flow-data/ALN/280.bam',
	'/data/BA/public_html/HTS-flow-data/ALN/491.bam'
	)

## mycER

miz1Peaksfiles <- c(
	'/data/BA/public_html/HTS-flow-data/secondary/16476/NARROW/3T9_MycER_Miz1_10E2_0h_peaks.xls',
	'/data/BA/public_html/HTS-flow-data/secondary/16476/NARROW/3T9_MycER_Miz1_10E2_4h_peaks.xls'
	)

miz1ChIPbamfiles <- c(
	'/data/BA/analysis/ChIPseq/MycER/miz1_10E2_tc/alnbam/Miz1.10E2.0min.bam',
	'/data/BA/analysis/ChIPseq/MycER/miz1_10E2_tc/alnbam/Miz1.10E2.4h.bam'
	)


save(
	miz1GSE44672peaksfiles, miz1GSE44672bamfiles, miz1GSE51011peaksfiles,
	miz1GSE51011bamfiles, miz1Peaksfiles, miz1ChIPbamfiles,
	file=file.path('..','data','paths_miz_binding.RData')
	)