% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/viewModelRates-methods.R
\docType{methods}
\name{viewModelRates}
\alias{viewModelRates}
\alias{viewModelRates,INSPEcT-method}
\title{Retrieve the modeled rates and concentrations}
\usage{
viewModelRates(object, feature)

\S4method{viewModelRates}{INSPEcT}(object, feature)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{feature}{A character indicating the feature to retireve, "synthesis", "degradation", "processing" for rates, "total" for total mRNA concentrations or "preMRNA" for premature mRNA concentrations}
}
\value{
A numeric matrix containing the values for the selected feature
}
\description{
Retrieve the modeled rates and concentrations

A method to access the modeld rates via the method \code{\link{modelRates}}
}
\examples{
data('mycerIds10', package='INSPEcT')
viewModelRates(mycerIds10, 'synthesis')
}

