% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/testingParams-methods.R
\docType{methods}
\name{modelSelection}
\alias{llrtests}
\alias{llrtests,INSPEcT-method}
\alias{llrtests,INSPEcT_model-method}
\alias{llrtests<-}
\alias{llrtests<-,INSPEcT-method}
\alias{llrtests<-,INSPEcT_model-method}
\alias{modelSelection}
\alias{modelSelection,INSPEcT-method}
\alias{modelSelection,INSPEcT_model-method}
\alias{modelSelection<-}
\alias{modelSelection<-,INSPEcT-method}
\alias{modelSelection<-,INSPEcT_model-method}
\alias{testingParams}
\alias{thresholds}
\alias{thresholds,INSPEcT-method}
\alias{thresholds,INSPEcT_model-method}
\alias{thresholds<-}
\alias{thresholds<-,INSPEcT-method}
\alias{thresholds<-,INSPEcT_model-method}
\title{Get or set parameters for model test and selection}
\usage{
modelSelection(object)

modelSelection(object) <- value

thresholds(object)

thresholds(object) <- value

llrtests(object)

llrtests(object) <- value

\S4method{modelSelection}{INSPEcT}(object)

\S4method{modelSelection}{INSPEcT}(object) <- value

\S4method{modelSelection}{INSPEcT_model}(object)

\S4method{modelSelection}{INSPEcT_model}(object) <- value

\S4method{thresholds}{INSPEcT}(object)

\S4method{thresholds}{INSPEcT}(object) <- value

\S4method{thresholds}{INSPEcT_model}(object)

\S4method{thresholds}{INSPEcT_model}(object) <- value

\S4method{llrtests}{INSPEcT}(object)

\S4method{llrtests}{INSPEcT}(object) <- value

\S4method{llrtests}{INSPEcT_model}(object)

\S4method{llrtests}{INSPEcT_model}(object) <- value
}
\arguments{
\item{object}{An object of class INSPEcT or INSPEcT_model}

\item{value}{A list or a character that will substitute the set of parameters
\itemize{
  \item modelSelection: A character, either "llr" to test whether a rate is 
    varying using log-likelihood testing framework or "aic" to choose
    the best model via Akaike Information Criterion (Default: "llr").
  \item thresholds: A named list containing the threshold that is used to 
    consider a model as accepted in terms of the chi-squared test and three 
    thresholds (one per each rate) that are used to consider a rate as variable
    using the Brown's method on the log-likelihood ratio tests
  \item llrtests: A list of three elements that represent, for each rate, the pairs 
    of models that will be compared via log likelihood ratio test to assess 
    whether the rate is variable or not
}}
}
\value{
See "value"
}
\description{
With this methods the user can personalize the criteria by which INSPEcT
selects a rate to be variable or constant. In particular, the model selection
criteria can be selected between log-likelihood ratio test and Akaike's information
criterion. In case log-likelihood ratio test is selected, the thresholds of 
chi-squared and Brown's method can be set (see Details section).
}
\details{
When log-likelihood is chosen as a criterion for model selection, different nested 
models can be compared to assess wheter a single rate is varying or constant. 
For example, in case we want to establish whether synthesis rate is constant or not
we can test the null hypothesis "all the rates are constant" against the alternative 
hypothesis "synthesis rate is changing". The null hypothesis is a special case
of the alternative hypothesis, therefore the models are nested. We can also assess
whether synthesis rate is constant or not by comparing the null hypothesis 
"degradation rate is changing" against the alternative hypothesis "degradation and
synthesis are changing". The method \code{\link{llrtests}} set the models 
that are compared to assess the variability of eache rate. Different comparisons will
be combined using Brown's method for combinig p-values.
Models are named with a short notation where synthesis is "a", degradation is "b"
and processing is "c". "0" is the model where all genes are kept constant
and "ab", for example is the model where synthesis rate and degradation rate 
are changing.
The user can also set the thresholds for Brown's p-value and chi-suqared p-value.
While the former set the threshold to assess whether a rate is variable or not over time,
the latter set the chi-squared threshold for a pair of model to be used via the
log-likelihood ratio test. In order for a pair to be used, at least one model of the 
pair should have a chi-squared p-value (goodness of fit) below the threshold.
The construction of a synthetic data-set can help in the choice of the correct 
parameters for the test (\code{\link{makeSimModel}}, \code{\link{makeSimDataset}}).
}
\examples{
data('mycerIds10', package='INSPEcT')
modelSelection(mycerIds10)
modelSelection(mycerIds10) <- 'aic'
thresholds(mycerIds10)
thresholds(mycerIds10)$chisquare <- 1e-3
thresholds(mycerIds10)$brown['synthesis'] <- 1e-3
llrtests(mycerIds10)
llrtests(mycerIds10)$synthesis <- list(c('0','a'), c('b','ab'))
}
\seealso{
\code{\link{makeSimModel}}, \code{\link{makeSimDataset}}
}

