% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sfPlot-methods.R
\docType{methods}
\name{sfPlot}
\alias{sfPlot}
\alias{sfPlot,INSPEcT-method}
\title{A nice plot to see scaling factors used for RNA-seq and 4sU-seq libraries}
\usage{
sfPlot(object)

\S4method{sfPlot}{INSPEcT}(object)
}
\arguments{
\item{object}{An object of class INSPEcT}
}
\value{
None
}
\description{
A nice plot to see scaling factors used for RNA-seq and 4sU-seq libraries

This method generates a plot that immediately shows the scaling factors used to scale
RNA- and 4sU-seq libraries and the possible relations between them. The ratio between the RNA- and the 
4sU-seq scaling can be in fact considered as a yield of the synthesis within the cells.
}
\examples{
data('rpkms', package='INSPEcT')
tpts <- c(0, 1/6, 1/3, 1/2, 1, 2, 4, 8, 16)
tL <- 1/6
mycerIds <- newINSPEcT(tpts, tL, rpkms$foursu_exons, rpkms$total_exons, 
	rpkms$foursu_introns, rpkms$total_introns, BPPARAM=SerialParam())
sfPlot(mycerIds)
}

