% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rocThresholds-methods.R
\docType{methods}
\name{rocThresholds}
\alias{rocThresholds}
\alias{rocThresholds,INSPEcT_model,INSPEcT-method}
\alias{rocThresholds,INSPEcT_model,INSPEcT_model-method}
\title{Display rate classification performance with thresholds visible at x-axis}
\usage{
rocThresholds(object, object2, cTsh = NULL, bTsh = NULL, xlim = c(1e-05,
  1))

\S4method{rocThresholds}{INSPEcT_model,INSPEcT_model}(object, object2,
  cTsh = NULL, bTsh = NULL, xlim = c(1e-05, 1))

\S4method{rocThresholds}{INSPEcT_model,INSPEcT}(object, object2, cTsh = NULL,
  bTsh = NULL, xlim = c(1e-05, 1))
}
\arguments{
\item{object}{An object of class INSPEcT_model, with true rates}

\item{object2}{An object of class INSPEcT or INSPEcT_model, with modeled rates}

\item{cTsh}{A numeric representing the threshold for the chi-squared test to consider a model as valid}

\item{bTsh}{A numeric representing the threshold for the Brown's method to consider a rate as varying}

\item{xlim}{A numeric representing limits for the x-axis (default is c(1-e-5,1))}
}
\value{
None
}
\description{
Display rate classification performance with thresholds visible at x-axis

A method to visualize the performance in the classification of synthesis, degradation
and processing rates based on the comparison of the original simulated rates and the one
obtained by the function \code{\link{modelRates}}. For each rate, classification performance is measured 
in terms of sensitivity and specificity using a ROC curve analysis. False negatives (FN) represent cases 
where the rate is identified as constant while it was simulated as varying. False positives (FP) represent 
cases where INSPEcT identified a rate as varying while it was simulated as constant. On the contrary, 
true positives (TP) and negatives (TN) are cases of correct classification of varying and constant rates, respectively. 
Consequently, at increasing brown p-values different sensitivity and specificity can be achieved.
}
\examples{
data('simRates', package='INSPEcT')
data('simData3rep', package='INSPEcT')
rocThresholds(simRates, simData3rep)
# Increase the Brown threshold for all rates (be more relaxed)
thresholds(simData3rep)$brown <- c(alpha=.05, beta=.05, gamma=.05)
rocThresholds(simRates, simData3rep)
}
\seealso{
\code{\link{makeSimModel}}, \code{\link{makeSimDataset}}, \code{\link{rocCurve}}
}

