% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rocCurve-methods.R
\docType{methods}
\name{rocCurve}
\alias{rocCurve}
\alias{rocCurve,INSPEcT_model,INSPEcT-method}
\alias{rocCurve,INSPEcT_model,INSPEcT_model-method}
\title{Display rate classification performance}
\usage{
rocCurve(object, object2, cTsh = NULL, plot = TRUE)

\S4method{rocCurve}{INSPEcT_model,INSPEcT_model}(object, object2, cTsh = NULL,
  plot = TRUE)

\S4method{rocCurve}{INSPEcT_model,INSPEcT}(object, object2, cTsh = NULL,
  plot = TRUE)
}
\arguments{
\item{object}{An object of class INSPEcT_model, with true rates}

\item{object2}{An object of class INSPEcT or INSPEcT_model, with modeled rates}

\item{cTsh}{A numeric representing the threshold for the chi-squared test to consider a model as valid;
if NULL the value is taken from the INSPEcT_model object}

\item{plot}{A logical indicating whether ROC curves should be plotted or not}
}
\value{
A list of objects of class pROC with summary of each roc curve
}
\description{
Display rate classification performance

A method to visualize the performance in the classification of synthesis, degradation
and processing rates based on the comparison of the original simulated rates and the one
obtained by the function \code{\link{modelRates}}. For each rate, classification performance is measured 
in terms of sensitivity and specificity using a ROC curve analysis. False negatives (FN) represent cases 
where the rate is identified as constant while it was simulated as varying. False positives (FP) represent 
cases where INSPEcT identified a rate as varying while it was simulated as constant. On the contrary, 
true positives (TP) and negatives (TN) are cases of correct classification of varying and constant rates, respectively. 
Consequently, sensitivity and specificity are computed using increasing thresholds for the brown p-values, 
and the ability of correctly classifying a rate is measured through the area under the curve (AUC) for each rate.
}
\examples{
data('simRates', package='INSPEcT')
data('simData3rep', package='INSPEcT')
rocCurve(simRates, simData3rep)
}
\seealso{
\code{\link{makeSimModel}}, \code{\link{makeSimDataset}}, \code{\link{rocThresholds}}
}

