% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Extract-methods.R
\docType{methods}
\name{removeModel}
\alias{removeModel}
\alias{removeModel,INSPEcT-method}
\title{remove modelling information from INSPEcT object}
\usage{
removeModel(object)

\S4method{removeModel}{INSPEcT}(object)
}
\arguments{
\item{object}{An Object of class INSPEcT}
}
\value{
An Object of class INSPEcT
}
\description{
remove modelling information from INSPEcT object

Remove the model from an INSPEcT object. It is required when subsetting
an INSPEcT object per time points because when removing time points
the modeling is not valid anymore.
}
\examples{
data('mycerIds10', package='INSPEcT')
mycerIds_5genes <- mycerIds10[1:5]

## This will turn out into an error:
\dontrun{mycerIds_5genes_5tpts <- mycerIds10[1:5, 1:5]
}

## Before subsetting time points, the model should be removed:
mycerIds_5genes_5tpts <- removeModel(mycerIds10)[1:5, 1:5]

## Also this will turn out into an error:
\dontrun{mycerIds10 <- modelRates(mycerIds10)}

## Before running the model again, or changing modeling parameters,
## the previous model should be removed:
mycerIds10_old <- mycerIds10
mycerIds10_new <- removeModel(mycerIds10)
modelingParams(mycerIds10_new)$useSigmoidFun <- FALSE
\dontrun{mycerIds10_new <- modelRates(mycerIds10_new)}
}

