% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ratesFirstGuess-methods.R
\docType{methods}
\name{ratesFirstGuessVar}
\alias{ratesFirstGuessVar}
\alias{ratesFirstGuessVar,INSPEcT-method}
\title{Retrieve pre-modeling rates and concentrations variance}
\usage{
ratesFirstGuessVar(object, feature)

\S4method{ratesFirstGuessVar}{INSPEcT}(object, feature)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{feature}{A character indicating the feature to retireve, "synthesis", "degradation", "processing" for rates, "total" for total mRNA concentrations or "preMRNA" for premature mRNA concentrations}
}
\value{
A numeric vector containing the values for the selected feature
}
\description{
Retrieve pre-modeling rates and concentrations variance

This method allow to access to the estimated variance of synthesis rates and pre mRNA and total mRNA 
concentrations the way they were calculated by the constructor function \code{\link{newINSPEcT}}.
}
\examples{
data('rpkms', package='INSPEcT')
tpts <- c(0, 1/6, 1/3, 1/2, 1, 2, 4, 8, 16)
tL <- 1/6
mycerIds <- newINSPEcT(tpts, tL, rpkms$foursu_exons, rpkms$total_exons, 
	rpkms$foursu_introns, rpkms$total_introns, BPPARAM=SerialParam())
ratesFirstGuessVar(mycerIds, 'synthesis')
}
\seealso{
\code{\link{newINSPEcT}}, \code{\link{ratesFirstGuess}}
}

