% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ratesFirstGuess-methods.R
\docType{methods}
\name{ratesFirstGuess}
\alias{ratesFirstGuess}
\alias{ratesFirstGuess,INSPEcT-method}
\title{Retrieve pre-modeling rates and concentrations}
\usage{
ratesFirstGuess(object, feature)

\S4method{ratesFirstGuess}{INSPEcT}(object, feature)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{feature}{A character indicating the feature to retireve, "synthesis", "degradation", "processing" for rates, "total" for total mRNA concentrations or "preMRNA" for premature mRNA concentrations}
}
\value{
A numeric matrix containing the values for the selected feature
}
\description{
Retrieve pre-modeling rates and concentrations

This method allow to access to the estimated synthesis, degradation, processing rates and pre mRNA and total mRNA 
concentrations the way they were calculated by the constructor function \code{\link{newINSPEcT}}.
}
\examples{
data('rpkms', package='INSPEcT')
tpts <- c(0, 1/6, 1/3, 1/2, 1, 2, 4, 8, 16)
tL <- 1/6
mycerIds <- newINSPEcT(tpts, tL, rpkms$foursu_exons, rpkms$total_exons, 
	rpkms$foursu_introns, rpkms$total_introns, BPPARAM=SerialParam())
# get estimated synthesis rates
ratesFirstGuess(mycerIds, 'synthesis')
}
\seealso{
\code{\link{newINSPEcT}}, \code{\link{ratesFirstGuessVar}}
}

