% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steady-state-methods.R
\docType{methods}
\name{plotMA}
\alias{plotMA}
\alias{plotMA,INSPEcT_diffsteady-method}
\title{MA-plot from base means and log fold changes}
\usage{
\S4method{plotMA}{INSPEcT_diffsteady}(object, ...)
}
\arguments{
\item{object}{An object of calss INSPEcT_diffsteady}

\item{...}{Additional parameters, see Details section}
}
\description{
Visualize the comparison between the rates calculated from two different INSPEcT objects
profiled in steady-state conditions.
}
\details{
Possible arguments to "plotMA":
\itemize{
\item "rate" - A character, which represent the rate to be visualized, either "synthesis", "processing" or "degradation". By default, "synthesis" is chosen.
\item "alpha" - A numeric, The confidence interval for significance (FDR), by default 0.1
\item "xlim" - A numeric vector of length 2, limits of x-axis, by default the range of the data.
\item "xlab" - A character, the label of x-axis, by default "log2 geometric mean"
\item "ylim" - A numeric vector of length 2, limits of y-axis, by default the range of the data.
\item "ylab" - A character, the label of y-axis, by default "log2 fold change"
\item "main" - A character, the title of the plot, by default the name of the visualized rate.
}
}
\examples{
data('simData3rep', package='INSPEcT')
data('simData3rep_2', package='INSPEcT')
diffrates <- compareSteady(simData3rep, simData3rep_2)
plotMA(diffrates, alpha=.5)
}
\seealso{
\url{http://en.wikipedia.org/wiki/MA_plot}
}

