% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotGene-methods.R
\docType{methods}
\name{plotGene}
\alias{plotGene}
\alias{plotGene,INSPEcT-method}
\title{Plot the pre-modeled and modeled profiles for one gene}
\usage{
plotGene(object, ix, fix.yaxis = FALSE)

\S4method{plotGene}{INSPEcT}(object, ix, fix.yaxis = FALSE)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{ix}{Eiher a rowname or a row number to select one single gene}

\item{fix.yaxis}{A logical, indicating whether the limits for y-axis of degradation and processing rates should be fixed
relative to their distributions}
}
\value{
A list containing total mRNA levels and their confidence interval (levels plus and minus
one standard deviation), pre-mRNA lelevs and their confidence intervals, synthsis rates and 
their confidence intervals, degradation rates and processing rates of the selected gene.
}
\description{
Plot the pre-modeled and modeled profiles for one gene

A method to see the shapes of the estimated synthesis, degradation and processing rates, pre-mRNA and total mRNA 
concentrations (solid thin lines) their variances (dashed lines) and the modeled rates and concentrations 
(ticker solid line) of a single gene.
}
\examples{
data('mycerIds10', package='INSPEcT')
plotGene(mycerIds10, 1)
}

