% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newINSPEcT-functions.R
\name{newINSPEcT}
\alias{newINSPEcT}
\title{Create a new INSPEcT object}
\usage{
newINSPEcT(tpts, labeling_time, rpkms_4su_exons, rpkms_total_exons,
  rpkms_4su_introns = NULL, rpkms_total_introns = NULL,
  BPPARAM = bpparam(), totalMedianNorm = TRUE, labeledMedianNorm = FALSE,
  totalSF = NULL, labeledSF = NULL, totalQuantileNorm = FALSE,
  labeledQuantileNorm = FALSE, simulatedData = FALSE,
  degDuringPulse = FALSE)
}
\arguments{
\item{tpts}{A vector of time points}

\item{labeling_time}{A number, lenght of the 4sU pulse}

\item{rpkms_4su_exons}{A matrix containing expression levels of 4su exons}

\item{rpkms_total_exons}{A matrix containing expression levels of total exons}

\item{rpkms_4su_introns}{A matrix containing expression levels of 4su introns}

\item{rpkms_total_introns}{A matrix containing expression levels of total introns}

\item{BPPARAM}{Configuration for BiocParallel parallelization. By default is set to bpparam()}

\item{totalMedianNorm}{A logical to perform median normalization over total RNA exons rpkms, it will apply also on introns}

\item{labeledMedianNorm}{A logical to perform median normalization over 4sU RNA exons rpkms, it will apply also on introns}

\item{totalSF}{A vector storing user defined normalization scale over Total RNA exons and introns rpkms}

\item{labeledSF}{A vector storing user defined normalization scale over 4sU RNA exons and introns rpkms}

\item{totalQuantileNorm}{A logical to perform to perform median normalization over total RNA exons rpkms, it will apply also on introns}

\item{labeledQuantileNorm}{A logical to perform to perform median normalization over 4sU RNA exons rpkms, it will apply also on introns}

\item{simulatedData}{A logical, set to TRUE in case the analysis is on simulated data}

\item{degDuringPulse}{A logical, set to TRUE in case of a long labelling time. Also degradation of newly synthesized transcripts will be taken into account}
}
\value{
An object of class INSPEcT with rates guessed, rates can be accessed by \code{\link{ratesFirstGuess}} method.
}
\description{
The function newINSPEcT creates a new instance of the class INSPEcT, provided the intronic and exonic RPKMs
of RNA- and 4sU-seq experiments at different time points, the time points, the labeling time and optionally
the scaling factor to normalize the libraries. The scaling factor to normalize the 4sU-seq libraries can be 
calculated by the function itself and this way of calulating the scaling factors gives robustness to the estimation
of sythesis, degradation and processing rates. 
In case only exonic RPKMs are provided, only synthesis and degradation rates can be estimated by the function newINSPEcT
and the scaling factors to normalize 4sU-seq libraries cannot be caluculated. To provide robustness to the procedure
the argument labeledSF is strongly suggested in this case.
}
\examples{
data('rpkms', package='INSPEcT')
tpts <- c(0, 1/6, 1/3, 1/2, 1, 2, 4, 8, 16)
tL <- 1/6
mycerIds <- newINSPEcT(tpts, tL, rpkms$foursu_exons, rpkms$total_exons, 
	rpkms$foursu_introns, rpkms$total_introns, BPPARAM=SerialParam())
}

