% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/modelingParams-methods.R
\docType{methods}
\name{modelingParams}
\alias{modelingParams}
\alias{modelingParams,INSPEcT-method}
\alias{modelingParams<-}
\alias{modelingParams<-,INSPEcT-method}
\title{Get and set number parameters for the modeling}
\usage{
modelingParams(object)

modelingParams(object) <- value

\S4method{modelingParams}{INSPEcT}(object)

\S4method{modelingParams}{INSPEcT}(object) <- value
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{value}{A list with new parameters}
}
\value{
List of parameters and their values
\itemize{
 \item nInit number of optimization to find the best functional representation of each 
   rate (by default 10)
 \item nIter number of max iteration during optimization (default is 300)
 \item na.rm A logical wheter missing values should be removed from estimated rates 
   (default is TRUE)
 \item verbose A logical wheter to be verbose or not (default is TRUE)
 \item estimateRatesWith Either "int" or "der". With "int" the degradation and processing
   rates are estimated integrating the system between one time point and the following. 
   With "der" degradation and processing rates are estimated using the derivative of total
   and pre mRNA. (default is "int")
 \item useSigmoidFun A logical, whether to choose between sigmoid and impulse function 
   to fit rates and concentrations. In case not, always impulse function is used. 
   (default is TRUE)
 \item testOnSmooth A logical, wheter models should be tested on smoothed pre-mRNA, 
   total mRNA and synthesis rates or not. (default is TRUE)
}
}
\description{
Get and set number parameters for the modeling

A method to get and set the parameters that will be used in the modeling of estimated rates and 
concentrations by the method \code{\link{modelRates}}
}
\examples{
data('mycerIds10', package='INSPEcT')
modelingParams(mycerIds10)
data('mycerIds10', package='INSPEcT')
mycerIds10 <- removeModel(mycerIds10)
modelingParams(mycerIds10)$useSigmoidFun <- FALSE
}
\seealso{
\code{\link{modelRates}}
}

