% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/modelRates-methods.R
\docType{methods}
\name{modelRates}
\alias{modelRates}
\alias{modelRates,INSPEcT-method}
\title{Launch the modeling process}
\usage{
modelRates(object, seed = NULL, BPPARAM = bpparam(), verbose = NULL)

\S4method{modelRates}{INSPEcT}(object, seed = NULL, BPPARAM = bpparam(),
  verbose = NULL)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{seed}{A numeric, indicatindg the seed to be set for reproducible results}

\item{BPPARAM}{Parallelization parameters for bplapply. By default bpparam()}

\item{verbose}{Either NULL or logical. If logical indicates whether to output some text
during computation or not, if NULL  it takes the information from the object
(see \code{\link{modelingParams}}) (Default: NULL)
used for parallelization (if nCores=1 doesn't parallelize). If NULL takes the information
from the object (see \code{\link{modelingParams}}) (Default: NULL)}
}
\value{
An object of class INSPEcT with modeled rates
}
\description{
Launch the modeling process with parameters set with \code{\link{modelingParams}}

This method model the synthesis, degradation and processign rates after their estimation by the constructor function
\code{\link{newINSPEcT}}. Estimated rates are not guaranteed to optimally describes provided input data yet. 
To this purpose, modeled rates can be generated and genes can be assigned to a transcriptional regulatory mechanism.
Modeled rates can be accessed via the method \code{\link{viewModelRates}} and gene classification according 
to the regulatory mechanism can be accessed by \code{\link{geneClass}}. The modeling procedure can be set by the
user by modyging the parameters via \code{\link{modelingParams}}
}
\details{
When modeling many genes, parallelization is strongly suggested to reduce computational time.
Since all genes run independently, the computational time is diveded by the number of
cores used/available.
However, when modeling more than 500 genes, it may happen that 
a single gene returns an error that escapes the try/catch controls of INSPEcT. 
With the parallel mode, the error will propagate on all genes that have been computed 
with the same processor (or core). To avoid this, the computation could be splitted in chunks
and the whole data set can be obtaied by combining the chunks (see Examples).
}
\examples{
data('rpkms', package='INSPEcT')
tpts <- c(0, 1/6, 1/3, 1/2, 1, 2, 4, 8, 16)
tL <- 1/6
mycerIds <- newINSPEcT(tpts, tL, rpkms$foursu_exons, rpkms$total_exons, 
	rpkms$foursu_introns, rpkms$total_introns, BPPARAM=SerialParam())
mycerIdsOneGene <- mycerIds[5]
## View modeling parameters
modelingParams(mycerIdsOneGene)
## Run the modeling in a reproducible way (setting seed)
mycerIdsOneGene <- modelRates(mycerIdsOneGene, seed=1, BPPARAM=SerialParam())
## view modeled synthesis rates
viewModelRates(mycerIdsOneGene, 'synthesis')
## view gene classes
geneClass(mycerIdsOneGene)

## Divide a parallel computation into chunks
\dontrun{
nCores(mycerIds) <- parallel::detectCores()
chunkSize <- 100
splitIdx <- ceiling(c(1:nGenes(mycerIds))/chunkSize)
chunks <- lapply(split(mycerIds, splitIdx), modelRates)
mycerIdsModeled <- do.call('combine', chunks)
}
}
\seealso{
\code{\link{viewModelRates}}, \code{\link{geneClass}}, \code{\link{modelingParams}}
}

