% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/makeSimModel-methods.R
\docType{methods}
\name{makeSimModel}
\alias{makeSimModel}
\alias{makeSimModel,INSPEcT-method}
\title{Build the synthetic rates shaped on a dataset}
\usage{
makeSimModel(object, nGenes, newTpts = NULL, probs = c(constant = 0.5,
  sigmoid = 0.3, impulse = 0.2), na.rm = TRUE, seed = NULL)

\S4method{makeSimModel}{INSPEcT}(object, nGenes, newTpts = NULL,
  probs = c(constant = 0.5, sigmoid = 0.3, impulse = 0.2), na.rm = TRUE,
  seed = NULL)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{nGenes}{A numeric with the number of synthtic genes to be created}

\item{newTpts}{A numeric verctor with time points of the synthtic dataset, if NULL the time points of the real dataset will be used}

\item{probs}{A numeric vector wich describes the probability of a rate to be constant, shaped like a sigmoid or like an impulse model}

\item{na.rm}{A logical that set whether missing values in the real dataset should be removed}

\item{seed}{A numeric to obtain reproducible results}
}
\value{
An object of class INSPEcT_model with synthetic rates
}
\description{
Build the synthetic rates shaped on a dataset

This method allow the creation of synthesis, degradation and processing rates for a certain number of genes.
The rates are created according to the distributions of the real data-set which is given as an input of the
method. Different proportions of constant varying rates can be set and a new vector of time points can be
provided. This method has to be used before the \code{\link{makeSimDataset}} method.
}
\details{
The method \code{\link{makeSimModel}} generates an object of class INSPEcT_model that stores the parametric functions to genrate clean rates of a time-course. To any of the rates also a noise variance is associate but not used yet. In a typical workflow the output of \code{\link{makeSimModel}} is the input of the method \code{\link{makeSimDataset}}, that build the noisy rates and concentrations, given a specified number of replicates.
}
\examples{
data('rpkms', package='INSPEcT')
tpts <- c(0, 1/6, 1/3, 1/2, 1, 2, 4, 8, 16)
tL <- 1/6
mycerIds <- newINSPEcT(tpts, tL, rpkms$foursu_exons, rpkms$total_exons, 
	rpkms$foursu_introns, rpkms$total_introns, BPPARAM=SerialParam())
## generate a synthtic data-set of 10 genes based on the real data-set
simRates <- makeSimModel(mycerIds, 10)
simData <- makeSimDataset(simRates, tpts, 1)
## measure sensitivity/sensibility of synthesis, degradation and processing
## rates identification
data('simRates', package='INSPEcT')
data('simData3rep', package='INSPEcT')
rocCurve(simRates, simData3rep)
## measure classification with a different threshold for the chi-suared 
## test acceptance of models
rocCurve(simRates, simData3rep, cTsh=.2)
## generate a synthtic data-set of 10 genes based on the real data-set
## with more replicates and more time points
\dontrun{
newTpts <- c(0, 1/6, 1/3, 1/2, 1, 1.5, 2, 4, 8, 12, 16, 24)
simRates <- makeSimModel(mycerIds, 10, newTpts=newTpts)
simData <- makeSimDataset(simRates, newTpts, 3)
}
}
\seealso{
\code{\link{makeSimDataset}}
}

