% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/makeModelRates-methods.R
\docType{methods}
\name{makeModelRates}
\alias{makeModelRates}
\alias{makeModelRates,INSPEcT-method}
\alias{makeModelRates,INSPEcT_model-method}
\title{Calculate modeled rates and concentrations}
\usage{
makeModelRates(object, ...)

\S4method{makeModelRates}{INSPEcT_model}(object, ...)

\S4method{makeModelRates}{INSPEcT}(object, ...)
}
\arguments{
\item{object}{An object of class INSPEcT_model}

\item{...}{additional arguments
tpts : A vector of time points where rates and concentrations have to be evaluated}
}
\value{
An object of class ExpressionSet containing the modeled rates and concentrations
}
\description{
Calculate modeled rates and concentrations

This function is used to evaluate rates and concentrations after modeling of the 
rates has been run with \code{\link{modelRates}}. The modeled rates are in functional 
form and can be evaluated at any time points.

This method can be used to regenerate the rates assiciated to the modeling, in case
some testing parameters has changed.
}
\examples{
data('mycerIds10', package='INSPEcT')
tpts <- c(0, 1/6, 1/3, 1/2, 1, 2, 4, 8, 16)
eSet <- makeModelRates(getModel(mycerIds10), tpts=tpts)
exprs(eSet)
data('mycerIds10', package='INSPEcT')
viewModelRates(mycerIds10, 'degradation')
## force every degradation rate to be accepted as variable
thresholds(getModel(mycerIds10))$brown <- c(synthesis=.01, degradation=1, processing=.01)
mycerIds10 <- makeModelRates(mycerIds10)
viewModelRates(mycerIds10, 'degradation')
}

