% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/inHeatmap-methods.R
\docType{methods}
\name{inHeatmap}
\alias{inHeatmap}
\alias{inHeatmap,INSPEcT-method}
\title{Heatmap that represent the fold changes of all the five features}
\usage{
inHeatmap(object, type = "pre-model", breaks = seq(-1, 1, length.out = 51),
  palette = colorRampPalette(c("green", "black", "firebrick3")),
  plot_matureRNA = FALSE, absoluteExpression = TRUE, rowLabels = NULL,
  clustering = TRUE, clustIdx = 3:5)

\S4method{inHeatmap}{INSPEcT}(object, type = "pre-model", breaks = seq(-1,
  1, length.out = 51), palette = colorRampPalette(c("green", "black",
  "firebrick3")), plot_matureRNA = FALSE, absoluteExpression = TRUE,
  rowLabels = NULL, clustering = TRUE, clustIdx = 3:5)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{type}{Eiher "pre-model" or "model" to switch between pre-modeled or modeled features}

\item{breaks}{A vector of breaks for the heatmap}

\item{palette}{A color generating function, output of colorRampPalette}

\item{plot_matureRNA}{A logical. If set to TRUE, matrue-mRNA is displayed instead of 
total-mRNA (default: FALSE)}

\item{absoluteExpression}{A logical. If set to FALSE, the plot representing the 
intensity of expression is omitted. (default=TRUE)}

\item{rowLabels}{A character that represent the label names that will be
shown on the y-axis of the heatmap. If NULL featureNames(object) will be shown
(default is NULL)}

\item{clustering}{A logical. If set to FALSE, it displys genes the order they are, 
with no clustering (default: TRUE)}

\item{clustIdx}{A numeric. Indicates which of the features are used for the 
clustering. 0=absoluteExpression; 1=total-mRNA/mature-mRNA; 2=preMRNA; 
3=synthesis; 4=degradation; 5=processing (default=3:5, meaning that
synthesis, degradation and processing are used for the clustering)}
}
\value{
A list of matrices containing the logRatios for total mRNA levels, pre-mRNA levels,
synthesis rates, degradation rates and processing rates. Matrices are ordered according to
the clustering.
}
\description{
Heatmap that represent the fold changes of all the five features

A method to see as an heatmap the logRatios of synthesis, degradation and processing rates and 
pre-mRNA and total mRNA concentration of a population of genes, either at the level of 
etimated or modeled rates.
}
\examples{
data('mycerIds10', package='INSPEcT')
inHeatmap(mycerIds10, 'pre-model')
inHeatmap(mycerIds10, 'model')
}

