% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/geneClass-methods.R
\docType{methods}
\name{geneClass}
\alias{geneClass}
\alias{geneClass,INSPEcT-method}
\alias{geneClass,INSPEcT_model-method}
\title{Retrieve the regulatory class for each gene}
\usage{
geneClass(object, bTsh = NULL, cTsh = NULL)

\S4method{geneClass}{INSPEcT_model}(object, bTsh = NULL, cTsh = NULL)

\S4method{geneClass}{INSPEcT}(object, bTsh = NULL, cTsh = NULL)
}
\arguments{
\item{object}{An object of class INSPEcT or INSPEcT_model}

\item{bTsh}{A numeric representing the p-value threshold for considering a rate as variable. P-values are calculated through \code{\link{ratePvals}}}

\item{cTsh}{A numeric representing the threshold for the chi-squared test to consider a model as valid}
}
\value{
A character containing the regulatory class for each gene
}
\description{
Retrieve the regulatory class for each gene

This method returns a factor that summarise the gene class (transcriptional regulatory mechanism) that
INSPEcT has assigned to each gene. The classification depends on the chi-squared and Brown's method
thresholds, that can be both provided as arguments. If the user decides a different thresholding respect to
the default, these new values can be permanently set within the object.
}
\examples{
data('mycerIds10', package='INSPEcT')
geneClass(mycerIds10)
# see the classification with another threshold for chi-squared test 
geneClass(mycerIds10, cTsh=.2)
# set the new threshold permanently within the object
thresholds(mycerIds10)$chisquare <- .2
}
\seealso{
\code{\link{ratePvals}}
}

