% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/steady-state-methods.R
\docType{methods}
\name{compareSteady}
\alias{compareSteady}
\alias{compareSteady,INSPEcT,INSPEcT-method}
\title{Generate an object of class INSPEcT_diffsteady from two objects of class INSPEcT}
\usage{
compareSteady(inspectIds1, inspectIds2)

\S4method{compareSteady}{INSPEcT,INSPEcT}(inspectIds1, inspectIds2)
}
\arguments{
\item{inspectIds1}{An object of calss INSPEcT}

\item{inspectIds2}{A second object of calss INSPEcT}
}
\value{
An object of class INSPEcT_diffsteady which contains both the absolute 
quantification of the rates as well as the comparison with the statistcal significance
associated for each gene and rate. (See \code{\link{INSPEcT_diffsteady-class}})
}
\description{
Generate an object of class INSPEcT_diffsteady from two objects of class INSPEcT

This method compares two object of class INSPEcT in order to identify differential usage
of synthesis, processing or degradation rates in two different steady-state conditions. 
The two INSPEcT objects must have been profiled with replicates in order to provide
a statistical significance to the differences between their rates.
}
\examples{
## load data
data('simRates', package='INSPEcT')
data('simData3rep', package='INSPEcT')
## generate a new data set with 3 replicate to make the comparison
newTpts <- c(0, 1/6)
simData3rep_2 <- makeSimDataset(simRates, newTpts, 3, seed=2)
## compare
diffrates <- compareSteady(simData3rep, simData3rep_2)
## visualize results
diffrates
}

