% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllGenerics.R, R/show-methods.R, R/steady-state-methods.R
\docType{class}
\name{INSPEcT_diffsteady-class}
\alias{INSPEcT_diffsteady-class}
\alias{degradation}
\alias{degradation,INSPEcT_diffsteady-method}
\alias{processing}
\alias{processing,INSPEcT_diffsteady-method}
\alias{show,INSPEcT_diffsteady-method}
\alias{synthesis}
\alias{synthesis,INSPEcT_diffsteady-method}
\title{An S4 class to represent comparisons between two steady-state conditions}
\usage{
synthesis(object)

processing(object)

degradation(object)

\S4method{show}{INSPEcT_diffsteady}(object)

\S4method{synthesis}{INSPEcT_diffsteady}(object)

\S4method{processing}{INSPEcT_diffsteady}(object)

\S4method{degradation}{INSPEcT_diffsteady}(object)
}
\arguments{
\item{object}{An object of class INSPEcT_model}
}
\value{
Method show for objects of class INSPEcT_model returns the number of
the genes that have been modeled
}
\description{
INSPEcT_diffsteady is a class able to store the results of the comparisons between two steady states.
An object of class INSPEcT_diffsteady is created with the method "compareSteady" applied on 
two "INSPEcT" objects (see \code{\link{compareSteady}}).
}
\details{
Methods associated to the class INSPEcT_diffsteady are:
\itemize{
  \item synthesis: Accessor to the synthesis rates and their comparisons.
  \item degradation: Accessor to the degradation rates and their comparisons.
  \item processing: Accessor to the processing rates and their comparisons.
 \item plotMA: visualization fuction for rates comparisons, see \code{\link{plotMA}}
}
}
\section{Slots}{

\describe{
\item{\code{synthesis}}{A data.frame which contains both input data and comparisons results regarding
synthesis rates}

\item{\code{degradation}}{A data.frame which contains both input data and comparisons results regarding
degradation rates}

\item{\code{processing}}{A data.frame which contains both input data and comparisons results regarding
processing rates}
}}
\examples{
data('simData3rep', package='INSPEcT')
data('simData3rep_2', package='INSPEcT')
diffrates <- compareSteady(simData3rep, simData3rep_2)
head(synthesis(diffrates))
head(processing(diffrates))
head(degradation(diffrates))
}

