% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/show-methods.R
\docType{class}
\name{INSPEcT-class}
\alias{INSPEcT-class}
\alias{show,INSPEcT-method}
\title{An S4 class to contain all rates and models generated by INSPEcT}
\usage{
\S4method{show}{INSPEcT}(object)
}
\arguments{
\item{object}{An object of class INSPEcT}
}
\value{
Method show for objects of class INSPEcT displays the main features
of the slots ratesFirstGuess, model and modelRates
}
\description{
INSPEcT is a class able to store all the estimated rates and concentrations (slot ratesFirstGuess), 
the modeled rates and concentrations (slot modelRates) and the model themselves (slot model).
Within the class INSPEcT other information regarding the experimental design are stored, such as the time
points where experiments were collected (slot tpts), the labeling time (slot tL) and the normalization scale
fators used for RNA- (totalSF) and 4sU-seq libraries (labeledSF). A list of parameters that will be used during the 
modeling process is stored within the slot params and can be accessed by \code{\link{modelingParams}}.
A new instance of the class INSPEcT can be generated by the constructor function \code{\link{newINSPEcT}}.
}
\details{
Methods that apply to INSPEcT class are

\code{\link[=Extract]{[}} \cr
\code{\link{AIC}} \cr
\code{\link{chisqmodel}} \cr
\code{\link{chisqtest}} \cr
\code{\link{combine}} \cr
\code{\link{dim}} \cr
\code{\link{featureNames}} \cr
\code{\link{geneClass}} \cr
\code{\link{getModel<-}} \cr
\code{\link{getModel}} \cr
\code{\link{inHeatmap}} \cr
\code{\link{labeledSF}}
\code{\link{llrtests}} \cr
\code{\link{logLik}} \cr
\code{\link{makeModelRates}} \cr
\code{\link{makeSimModel}} \cr
\code{\link{modelingParams<-}} \cr
\code{\link{modelingParams}} \cr
\code{\link{modelRates}} \cr
\code{\link{modelSelection}} \cr
\code{\link{nGenes}} \cr
\code{\link{nTpts}} \cr
\code{\link{plotGene}} \cr
\code{\link{ratePvals}} \cr
\code{\link{ratesFirstGuessVar}} \cr
\code{\link{ratesFirstGuess}} \cr
\code{\link{removeModel}} \cr
\code{\link{sfPlot}} \cr
\code{\link{thresholds}} \cr
\code{\link{totalSF}} \cr
\code{\link{tpts}} \cr
\code{\link{viewModelRates}} \cr
}
\section{Slots}{

\describe{
\item{\code{params}}{A list of parameters of the modeling part}

\item{\code{ratesFirstGuess}}{An object of class ExpressionSet that contains all the rates and concentrations guessed from the first part of INSPEcT analysis (before modeling)}

\item{\code{precision}}{A matrix that contains the estimated precision of the rates. Rows represent genes, Columns represent time points.}

\item{\code{model}}{An object of class INSPEcT_model that contains the output of the mdoeling}

\item{\code{modelRates}}{An object of class ExpressionSet that contains all modeled the rates and concentrations}

\item{\code{tpts}}{A numeric vector of the time-points}

\item{\code{labeledSF}}{A numeric vector of the scaling factor used for inter time-point normalization of 4sU-seq libraries}

\item{\code{totalSF}}{A numeric vector of the scaling factor used for inter time-point normalization of RNA-seq libraries}

\item{\code{tL}}{A numeric containing the length of the 4sU pulse}
}}

