#' @rdname viewModelRates
#'
#' @description
#' A method to access the modeld rates via the method \code{\link{modelRates}}
#' @param object An object of class INSPEcT
#' @param feature A character indicating the feature to retireve, "synthesis", "degradation", "processing" for rates, "total" for total mRNA concentrations or "preMRNA" for premature mRNA concentrations
#' @return A numeric matrix containing the values for the selected feature
#' @examples
#' data('mycerIds10', package='INSPEcT')
#' viewModelRates(mycerIds10, 'synthesis')
setMethod('viewModelRates', 'INSPEcT', function(object, feature) {
	ix <- pData(object@modelRates)$feature == feature
	exprs(object@modelRates)[,ix, drop=FALSE]
	})
