##################################
### RNAseq_aligned_reads.xls ########
##################################

load(file=file.path('data','rna_libraries_stats.RData'))

RNA_stats <- rbind(total_stats,foursu_stats)
RNA_stats <- data.frame(
	sample = rownames(RNA_stats),
	RNA_stats,
	stringsAsFactors=FALSE
	)

write.table(RNA_stats, row.names=FALSE, quote=FALSE, sep='\t', 
	file=file.path('tables','RNAseq_aligned_reads.xls'))

####################################
#####
##########################################

library(INSPEcT)
load(file.path('data','3T9MycER_INSPEcTdataset.RData'))
load(
	# mycTSSgr,polTSSgr,polGBgr,polTESgr,
	# inputMycScales,mycSampleNorm,inputPol2Scales,pol2SampleNorm,
	# mycTSSPeaks,polTSSPeaks,polGBPeaks,polTESPeaks,
	# mycTSSn,polTSSn,polGBn,polTESn,
	file=file.path('data','ChIPseq_data.RData'))
load(file.path('data','filtered.rds'))

library(org.Mm.eg.db)
eg2symb <- as.list(org.Mm.egSYMBOL)
conv <- eg2symb[filtered]
conv[sapply(conv, is.null)] <- NA
conv <- sapply(conv, '[[', 1)

mature <- viewModelRates(mycerIds, 'total')-viewModelRates(mycerIds, 'preMRNA')
colnames(mature) <- sub('total','mature',colnames(mature))
inspectRates <- cbind(
	mature	
	, viewModelRates(mycerIds, 'preMRNA')
	, viewModelRates(mycerIds, 'synthesis')
	, viewModelRates(mycerIds, 'degradation')
	, viewModelRates(mycerIds, 'processing')
	)

colnames(mycTSSn) <- paste('mycTSSshare',colnames(mycTSSn), sep='_')
colnames(polTSSn) <- paste('polTSS',colnames(polTSSn), sep='_')
colnames(polGBn) <- paste('polGB',colnames(polGBn), sep='_')
colnames(polTESn) <- paste('polTES',colnames(polTESn), sep='_')

regularedGenesFeatures <- data.frame(
	EntrezID = filtered,
	GeneSymbol = conv,
	mycTSSn[filtered,],
	polTSSn[filtered,],
	polGBn[filtered,],
	polTESn[filtered,],
	inspectRates[filtered,],
	stringsAsFactors=FALSE
	)

colnames(regularedGenesFeatures) <- sub('_0min$', '_0', colnames(regularedGenesFeatures))
colnames(regularedGenesFeatures) <- sub('_10min$', '_0.17', colnames(regularedGenesFeatures))
colnames(regularedGenesFeatures) <- sub('_20min$', '_0.33', colnames(regularedGenesFeatures))
colnames(regularedGenesFeatures) <- sub('_30min$', '_0.5', colnames(regularedGenesFeatures))
colnames(regularedGenesFeatures) <- sub('_2h$', '_2', colnames(regularedGenesFeatures))
colnames(regularedGenesFeatures) <- sub('_4h$', '_4', colnames(regularedGenesFeatures))

write.table(regularedGenesFeatures, row.names=FALSE, quote=FALSE, sep='\t', 
	file=file.path('tables','regulated_genes_features.xls'))








