source(file.path('primary_data_analysis','00_library_of_functions.R'))

#############
## panel A #####
##############

load(file=file.path('data','ChIPseq_data.RData'))
load(file=file.path('data','paths_3T9_mycER.RData'))
load(file=file.path('data','elongation_tx.RData'))

sat <- 1

drawLine <- function(mat, linetsh)
{
	if(linetsh>0) {
		linecoords <- rbind(
			0:(ncol(mat)-1),
			apply( mat < linetsh , 2, function(x) max(0,which(x)))
			)
		linecoords <- linecoords/apply(linecoords,1,max)
	}
	if(linetsh<0) {
		linecoords <- rbind(
			0:(ncol(mat)-1),
			apply(mat > linetsh , 2, function(x) max(0,which(x)))
			)
		linecoords <- linecoords/apply(linecoords,1,max)
	}
	for(i in 1:(ncol(linecoords)-1)) 
		lines(linecoords[1,i:(i+1)],linecoords[2,i:(i+1)], lwd=3)
}

pdf(file.path('figures','S4A.pdf'), width=3.5)

par(mfrow=c(5,2), mar=c(1,1,1,1))

imageHclust(l2fcMat$Mthfd1l$lab, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Mthfd1l$lab, .2)

imageHclust(l2fcMat$Mthfd1l$pol, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Mthfd1l$lab, .2)

imageHclust(l2fcMat$Ddx10$lab, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Ddx10$lab, .2)

imageHclust(l2fcMat$Ddx10$pol, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Ddx10$lab, .2)

imageHclust(l2fcMat$Eml4$lab, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Eml4$lab, .2)

imageHclust(l2fcMat$Eml4$pol, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Eml4$lab, .2)

imageHclust(l2fcMat$Bcar3$lab, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Bcar3$lab, -.2)

imageHclust(l2fcMat$Bcar3$pol, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Bcar3$lab, -.2)

imageHclust(l2fcMat$Ctnna1$lab, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Ctnna1$lab, -.2)

imageHclust(l2fcMat$Ctnna1$pol, Rowv=FALSE, breaks=seq(-sat,sat,length.out=201), 
	col=colorRampPalette(c('blue','white','red'))(200))
drawLine(l2fcMat$Ctnna1$lab, -.2)

dev.off()

#############
## panel B #####
##############

pseudogenes <- readRDS(file.path('data','pseudogenes.rds'))
load(file=file.path('data','RNAPII_modeling_elaborated.RData'))

pseudogenes_ordered <- pseudogenes[ordRows]
optimized_models_ordered <- optimized_models[ordRows]

clN <- 3

cl1_VVKfV <- optimized_models_ordered[[clN]]
cl1_VVKfV[[3]] <- list(fun=constantModelP, params=evalModel(0,cl1_VVKfV[[3]]), 
	df=1, log_transf=FALSE, log_shift=NaN)

pdf(file.path('figures','S4B.pdf'), height=4, width=4)
rnapii_plot(tpts, pseudogenes_ordered[[clN]], cl1_VVKfV, panels=4)
rnapii_plot(tpts, pseudogenes_ordered[[clN]], optimized_models_ordered[[clN]], panels=4, lty=2, lwd=1, add=TRUE)
dev.off()

###################
## panel C-D-E ######
##################

library(INSPEcT)
load(file.path('data','allfeatures.rds'))
load(file.path('data','filteredk1k2var.rds'))
load(file.path('data','3T9MycER_INSPEcTdataset.RData'))
load(file.path('data','halfResponses.RData'))

processingLR <- allfeatures[filteredk1k2var, grep('processingLR', colnames(allfeatures))[-1]]
procMaxResp <- processingLR[cbind(1:nrow(processingLR),apply(abs(processingLR), 1, which.max))]
synthesisLR <- allfeatures[filteredk1k2var, grep('synthesisLR', colnames(allfeatures))[-1]]
synthMaxResp <- synthesisLR[cbind(1:nrow(synthesisLR),apply(abs(synthesisLR), 1, which.max))]
quandrant1 <- sign(procMaxResp)>0 & sign(synthMaxResp)>0
quandrant2 <- sign(procMaxResp)>0 & sign(synthMaxResp)<0
quandrant3 <- sign(procMaxResp)<0 & sign(synthMaxResp)<0
quandrant4 <- sign(procMaxResp)<0 & sign(synthMaxResp)>0
concordant <- quandrant1 | quandrant3
discordant <- !concordant

pdf(file.path('figures','S4C.pdf'), height=4, width=4)
plot(hr$synthesis[discordant], hr$processing[discordant], log='xy', 
	col=ifelse(sign(synthMaxResp[discordant])==1, 'red', 'blue'),
	xlab='Synthesis rate',
	ylab='Processing rate',
	main='half-response time', 
	pch=20, cex=.8)
abline(0,1)
dev.off()

pdf(file.path('figures','S4D.pdf'), height=4, width=4)
plot(hr$premrna, hrT0k2$premrna, log='xy', pch=20, cex=.8, 
	xlab='pre-mRNA half response time', 
	ylab='pre-mRNA half response time (constant k2)')
abline(0,1)
dev.off()

require(org.Mm.eg.db)
symb2eg <- as.list(org.Mm.egSYMBOL2EG)
eid <- symb2eg[['Prickle1']]

pdf(file.path('figures','S4E.pdf'), height=3, width=15)
plotGene(mycerIds, eid)
plotGene(mycerIdsk1k2T0k2, eid)
dev.off()

#####################
## panel F-G-H-I ######
####################

library(pheatmap)
load(file.path('data','allfeatures.rds'))
load(file.path('data','upGenes.rds'))
load(file.path('data','downGenes.rds'))
load(file.path('data','filteredk1k2var.rds'))
load(file.path('data','dexseq_genes2plot.RData'))

library(TxDb.Mmusculus.UCSC.mm9.knownGene)
require(org.Mm.eg.db)
symb2eg <- as.list(org.Mm.egSYMBOL2EG)

## collect information on the genes with variable processing

p3 <- allfeatures[,paste0('synthesis_',c('0min','10min','20min','30min','2h','4h'))]/
	allfeatures[,grep('polGB_',colnames(allfeatures),value=T)]
p3LRtmp <- log2(p3[,-1]) - log2(p3[,1])
p3LR <- cbind(p3LRtmp[,1:3],NA,NA,p3LRtmp[,4:5],NA,NA,NA)
varProcGenes <- rownames(allfeatures)[rowSums(abs(allfeatures[,
	grep('processingLR_',colnames(allfeatures))]),na.rm=T)>0]

##### exons (panel G)

load(file=file.path('data','dexseq_exonsDF.RData'))

## annotate features according to their position in the transcript
exonsDFbyGroup <- split(exonsDF, exonsDF$groupID)
exonsDF <- do.call('rbind', exonsDFbyGroup)

## create a summmary table which contains only significant events and report them
## as a score of their response based on the pvalue [ -log10(Padj)*sign(Log2fold) ]
exonsTableSignif <- eventsTableSignif(exonsDF, 
	signifPadj=.05, signifLog2fold=0, max_saturate=3)

# saturare TSSdist
exonsTableSignif$TSSdist[exonsTableSignif$TSSdist>1e5] <- 1e5
exonsTableSignif$TESdist[exonsTableSignif$TESdist>1e5] <- 1e5

## heatmap of the events in up-regulated genes

exonsTableSignifUP <- exonsTableSignif[exonsTableSignif$groupID %in% upGenes,]
proc <- allfeatures[exonsTableSignifUP$groupID,
		grep('processingLR_',colnames(allfeatures))]
row_processing_annot <- factor(sign(proc[cbind(1:nrow(proc),apply(abs(proc), 1, which.max))]))
levels(row_processing_annot) <- c('down','constant','up')
exonsTableSignifUPRowAnnot <- data.frame(
	processing_class=row_processing_annot,
	TSSdist=exonsTableSignifUP$TSSdist,
	TESdist=exonsTableSignifUP$TESdist,
	TSSreldist=exonsTableSignifUP$TSSreldist,
	row.names=rownames(exonsTableSignifUP)
	)
exonsTableSignifUPColAnnot <- data.frame(
	processingLR=apply(allfeatures[intersect(unique(exonsTableSignifUP$groupID),varProcGenes),
			grep('processingLR_',colnames(allfeatures))][,-1],
		2,mean,na.rm=T),
	p3LR=apply(p3LR[exonsTableSignifUP$groupID,],2,mean,na.rm=T),
	row.names=grep('padj',colnames(exonsTableSignifUP),value=T)
	)
ann_colors <- list(
    processing_class = c("down"='blue', "constant"='beige', "up"='red'),
    processingLR = c('blue','beige'),
    p3LR = c('blue','beige'),
    TSSdist=c('beige','black'),
    TESdist=c('beige','black'),
    TSSreldist=c('beige','mediumpurple4')
)
ord <- hclust(dist(exonsTableSignifUP[,grep('padj',colnames(exonsTableSignifUP),value=T)]))$order
pheatmap(exonsTableSignifUP[ord,grep('padj',colnames(exonsTableSignifUP),value=T)], 
	cluster_rows=F, cluster_cols=F,
	breaks = seq(-3, 3, length.out=100),
	show_rownames = F, annotation_row = exonsTableSignifUPRowAnnot,
	annotation_col = exonsTableSignifUPColAnnot
	, annotation_colors = ann_colors
	, file = file.path('figures','S4Ga.pdf'), width = 5.5, height=7
	)

## heatmap of the events in down-regulated genes

exonsTableSignifDOWN <- exonsTableSignif[exonsTableSignif$groupID %in% downGenes,]
proc <- allfeatures[exonsTableSignifDOWN$groupID,
		grep('processingLR_',colnames(allfeatures))]
row_processing_annot <- factor(sign(proc[cbind(1:nrow(proc),apply(abs(proc), 1, which.max))]))
levels(row_processing_annot) <- c('down','constant','up')
exonsTableSignifDOWNRowAnnot <- data.frame(
	processing_class=row_processing_annot,
	TSSdist=exonsTableSignifDOWN$TSSdist,
	TESdist=exonsTableSignifDOWN$TESdist,
	TSSreldist=exonsTableSignifDOWN$TSSreldist,
	row.names=rownames(exonsTableSignifDOWN)
	)
exonsTableSignifDOWNColAnnot <- data.frame(
	processingLR=apply(allfeatures[intersect(unique(exonsTableSignifDOWN$groupID),varProcGenes),
			grep('processingLR_',colnames(allfeatures))][,-1],
		2,mean,na.rm=T),
	p3LR=apply(p3LR[exonsTableSignifDOWN$groupID,],2,mean,na.rm=T),
	row.names=grep('padj',colnames(exonsTableSignifDOWN),value=T)
	)
ann_colors <- list(
    processing_class = c("down"='blue', "constant"='beige', "up"='red'),
    processingLR = c('beige','red'),
    p3LR = c('beige','red'),
    TSSdist=c('beige','black'),
    TESdist=c('beige','black'),
    TSSreldist=c('beige','mediumpurple4')
)
ord <- hclust(dist(exonsTableSignifDOWN[,grep('padj',colnames(exonsTableSignifDOWN),value=T)]))$order
pheatmap(exonsTableSignifDOWN[ord,grep('padj',colnames(exonsTableSignifDOWN),value=T)], 
	cluster_rows=F, cluster_cols=F,
	breaks = seq(-3, 3, length.out=100),
	show_rownames = F, annotation_row = exonsTableSignifDOWNRowAnnot,
	annotation_col = exonsTableSignifDOWNColAnnot
	, annotation_colors = ann_colors
	, file = file.path('figures','S4Gb.pdf'), width = 5.5, height=7
	)

##### introns (panel I)

load(file=file.path('data','dexseq_intronsDF.RData'))

## annotate introns according to their position in the transcript
intronsDFbyGroup <- split(intronsDF, intronsDF$groupID)
intronsDFbyGroupAnn <- lapply(intronsDFbyGroup, function(x) {
	x$ann <- annotateRelativePos(x$featureID)
	return(x)
	})
intronsDFann <- do.call('rbind', intronsDFbyGroupAnn)

## remove events at 5 prime end (f_1 and f_2)
intronsDFannThreePrime <- intronsDFann[!(intronsDFann$ann %in% c('f_1','f_2')),]

## create a summmary table which contains only significant events and report them
## as a score of their response based on the pvalue [ -log10(Padj)*sign(Log2fold) ]
intronsTableSignif <- eventsTableSignif(intronsDFannThreePrime, 
	signifPadj=.05, signifLog2fold=0, max_saturate=3)

# saturare TSSdist
intronsTableSignif$TSSdist[intronsTableSignif$TSSdist>1e5] <- 1e5
intronsTableSignif$TESdist[intronsTableSignif$TESdist>1e5] <- 1e5

## heatmap of the events in up-regulated genes
intronsTableSignifUP <- intronsTableSignif[intronsTableSignif$groupID %in% upGenes,]
proc <- allfeatures[intronsTableSignifUP$groupID,
		grep('processingLR_',colnames(allfeatures))]
row_processing_annot <- factor(sign(proc[cbind(1:nrow(proc),apply(abs(proc), 1, which.max))]))
levels(row_processing_annot) <- c('down','constant','up')
intronsTableSignifUPRowAnnot <- data.frame(
	processing_class=row_processing_annot,
	TSSdist=intronsTableSignifUP$TSSdist,
	TESdist=intronsTableSignifUP$TESdist,
	TSSreldist=intronsTableSignifUP$TSSreldist,
	row.names=rownames(intronsTableSignifUP)
	)
intronsTableSignifUPColAnnot <- data.frame(
	processingLR=apply(allfeatures[intronsTableSignifUP$groupID,
			grep('processingLR_',colnames(allfeatures))][,-1],
		2,mean,na.rm=T),
	p3LR=apply(p3LR[intronsTableSignifUP$groupID,],2,mean,na.rm=T),
	row.names=grep('padj',colnames(intronsTableSignifUP),value=T)
	)
ann_colors <- list(
    processing_class = c("down"='blue', "constant"='beige', "up"='red'),
    processingLR = c('blue','beige'),
    p3LR = c('blue','beige'),
    TSSdist=c('beige','black'),
    TESdist=c('beige','black'),
    TSSreldist=c('beige','mediumpurple4')
)
ord <- hclust(dist(intronsTableSignifUP[,grep('padj',colnames(intronsTableSignifUP),value=T)]))$order
pheatmap(intronsTableSignifUP[ord,grep('padj',colnames(intronsTableSignifUP),value=T)], 
	cluster_rows=F, cluster_cols=F,
	breaks = seq(-3, 3, length.out=100),
	show_rownames = F, annotation_row = intronsTableSignifUPRowAnnot,
	annotation_col = intronsTableSignifUPColAnnot
	, annotation_colors = ann_colors
	, file = file.path('figures','S4Ia.pdf'), width = 5.5, height=7
	)

## heatmap of the events in down-regulated genes
intronsTableSignifDOWN <- intronsTableSignif[intronsTableSignif$groupID %in% downGenes,]
proc <- allfeatures[intronsTableSignifDOWN$groupID,
		grep('processingLR_',colnames(allfeatures))]
row_processing_annot <- factor(sign(proc[cbind(1:nrow(proc),apply(abs(proc), 1, which.max))]))
levels(row_processing_annot) <- c('down','constant','up')
intronsTableSignifDOWNRowAnnot <- data.frame(
	processing_class=row_processing_annot,
	TSSdist=intronsTableSignifDOWN$TSSdist,
	TESdist=intronsTableSignifDOWN$TESdist,
	TSSreldist=intronsTableSignifDOWN$TSSreldist,
	row.names=rownames(intronsTableSignifDOWN)
	)
intronsTableSignifDOWNColAnnot <- data.frame(
	processingLR=apply(allfeatures[intronsTableSignifDOWN$groupID,
			grep('processingLR_',colnames(allfeatures))][,-1],
		2,mean,na.rm=T),
	p3LR=apply(p3LR[intronsTableSignifDOWN$groupID,],2,mean,na.rm=T),
	row.names=grep('padj',colnames(intronsTableSignifDOWN),value=T)
	)
ann_colors <- list(
    processing_class = c("down"='blue', "constant"='beige', "up"='red'),
    processingLR = c('blue','beige','red'),
    p3LR = c('beige','red'),
    TSSdist=c('beige','black'),
    TESdist=c('beige','black'),
    TSSreldist=c('beige','mediumpurple4')
)
ord <- hclust(dist(intronsTableSignifDOWN[,grep('padj',colnames(intronsTableSignifDOWN),value=T)]))$order
pheatmap(intronsTableSignifDOWN[ord,grep('padj',colnames(intronsTableSignifDOWN),value=T)], 
	cluster_rows=F, cluster_cols=F,
	breaks = seq(-3, 3, length.out=100),
	show_rownames = F, annotation_row = intronsTableSignifDOWNRowAnnot,
	annotation_col = intronsTableSignifDOWNColAnnot
	, annotation_colors = ann_colors
	, file = file.path('figures','S4Ib.pdf'), width = 5.5, height=7
	)

## example ( panel F )

pdf(file.path('figures','S4F.pdf'), height=5)
suppressWarnings(plotDEXSeq(dexseq_gene1, symb2eg[['Wdr59']]))
dev.off()

## example ( panel H )

pdf(file.path('figures','S4H.pdf'), height=5)
suppressWarnings(plotDEXSeq(dexseq_gene2, symb2eg[['Arhgap44']]))
dev.off()

### numbers

exonsUP <- unique(exonsTableSignifUP$groupID)
exonsDOWN <- unique(exonsTableSignifDOWN$groupID)
intronsUP <- unique(intronsTableSignifUP$groupID)
intronsDOWN <- unique(intronsTableSignifDOWN$groupID)

paste('Up-regulated genes affected by exon-inclusion alterations:', length(exonsUP))
# [1] "Up-regulated genes affected by exon-inclusion alterations: 363"
paste('Down-regulated genes affected by exon-inclusion alterations:', length(exonsDOWN))
# [1] "Down-regulated genes affected by exon-inclusion alterations: 453"
paste('Up-regulated genes affected by intron-retention alterations:', length(intronsUP))
# [1] "Up-regulated genes affected by intron-retention alterations: 368"
paste('Down-regulated genes affected by intron-retention alterations:', length(intronsDOWN))
# [1] "Down-regulated genes affected by intron-retention alterations: 510"

exonsAltered <- c(exonsUP, exonsDOWN)
intronsAltered <- c(intronsUP, intronsDOWN)
regulatedGenes <- c(upGenes, downGenes)

signif(fisher.test(table(regulatedGenes %in% exonsAltered, regulatedGenes %in% intronsAltered))$p.value, 3)
# [1] 1.06e-22








