source(file.path('primary_data_analysis','00_library_of_functions.R'))
load(file.path('data','allfeatures.rds'))
load(file.path('data','filteredk1k2var.rds'))

featurespK1k2 <- c(
	"synthesisLR_10min","synthesisLR_20min","synthesisLR_30min", "synthesisLR_1h","synthesisLR_1.5h",
	"synthesisLR_2h","synthesisLR_4h", "synthesisLR_8h","synthesisLR_12h","synthesisLR_16h",
	"premrnaLR_10min","premrnaLR_20min","premrnaLR_30min", "premrnaLR_1h","premrnaLR_1.5h",
	"premrnaLR_2h","premrnaLR_4h", "premrnaLR_8h","premrnaLR_12h","premrnaLR_16h",
	"processingLR_10min","processingLR_20min","processingLR_30min","processingLR_1h","processingLR_1.5h",
	"processingLR_2h","processingLR_4h","processingLR_8h","processingLR_12h","processingLR_16h"
	)

p3 <- allfeatures[,paste0('synthesis_',c('0min','10min','20min','30min','2h','4h'))]/
	allfeatures[,grep('polGB_',colnames(allfeatures),value=T)]
p3LR <- log2(p3[,-1]) - log2(p3[,1])
colnames(p3LR) <- paste0('p3LR_',c('10min','20min','30min','2h','4h'))
fig4data <- cbind(allfeatures[,featurespK1k2],p3LR)[filteredk1k2var,]

pdf(file.path('figures','4.pdf'), height=12, width=4)
par(mar=c(1,1,1,1))
imageHclust(fig4data, 
	Colv=FALSE,
	colsep=makeBreaks(colnames(fig4data)),
	breaks=seq(-log2(1.5),log2(1.5),length.out=22),
	sepwidth=3
	)
dev.off()

