source(file.path('primary_data_analysis','00_library_of_functions.R'))
load(file.path('data','allfeatures.rds'))
load(file.path('data','filteredk1var.rds'))

load(
	#pol2modelingfeatures, pol2modelingclust, 
	file=file.path('data','pol2modelingclustering.RData'))

load(
	# tpts,tptsfine,tptslog,tptsfine,
	# null_models, singlevar_models, optimized_models, 
	# fluxes, relfluxes, relfluxesNeg, firings, relfirings, elongations, relelongations, 
	# releases, relreleases, relrates, ordRows, 
	file=file.path('data','RNAPII_modeling_elaborated.RData')
	)

clIdx <- which(pol2modelingclust$kmeans$size>50)

## panel A

orderedpol2modelingfeatures <- c("polTSS_0min","polTSSLR_10min","polTSSLR_20min",
	"polTSSLR_30min","polTSSLR_2h","polTSSLR_4h","polGB_0min","polGBLR_10min",
	"polGBLR_20min","polGBLR_30min","polGBLR_2h","polGBLR_4h","polTES_0min",
	"polTESLR_10min","polTESLR_20min","polTESLR_30min","polTESLR_2h",
	"polTESLR_4h","synthesis_0min","synthesisLR_10min","synthesisLR_20min",
	"synthesisLR_30min","synthesisLR_2h","synthesisLR_4h")

allfeatures3A <- allfeatures[filteredk1var,orderedpol2modelingfeatures]
pdf(file.path('figures','3A.pdf'), height=24, width=13)
hmOut <- imageKmeans(allfeatures3A, 
	aicKmeans=pol2modelingclust, 
	Colv=FALSE,
	colsep=makeBreaks(unique(orderedpol2modelingfeatures)),
	breaks=seq(-log2(1.5),log2(1.5),length.out=22),
	clustToPlot=clIdx,
	clustOrd=ordRows,
	sepwidth=3
	)
dev.off()

## panel C

pseudogenes <- readRDS(file.path('data','pseudogenes.rds'))

maxSynthResp <- sapply(pseudogenes, function(x) maxResp(t(x))[4])

varexpl_oneV <- sapply(1:4, function(i) {
	nullvar <- sapply(null_models,'[[', 'value')
	modelvar <- sapply(singlevar_models[,i],'[[', 'value')
	modelvar[sapply(modelvar,is.null)] <- NA; modelvar <- unlist(modelvar)
	( nullvar - modelvar )/nullvar
	})

sat <- 1
palette <- colorRampPalette(c('darkblue','blue','beige','red','darkred'))(21)

pdf(file.path('figures','3C.pdf'), height=3.5, width=9)

layout(t(as.matrix(c(1,1,2,3,rep(4,10),5,rep(6,10),7,rep(8,10),9,rep(10,10)))))
par(mar=c(5,.2,.2,.2)+.1)
ticks <- (tptslog - tptslog[1])/max(tptslog - tptslog[1])
plot.new()
imageHclust(t(as.matrix(rev(maxSynthResp[ordRows]))), Rowv=FALSE, breaks=seq(-sat,sat,length.out=22), xaxt='n', yaxt='n', col=palette)
axis(2,at=seq(0,1,length.out=length(ordRows)), 
	labels=table(pol2modelingclust$kmeans$cluster)[clIdx][rev(ordRows)],las=2,tick=FALSE)
image(t(as.matrix(rev(varexpl_oneV[ordRows,1]))), 
	breaks=seq(0,1,length.out=21), col=colorRampPalette(c('white','black'))(20), xaxt='n', yaxt='n')
imageHclust(t(relfluxes)[rev(ordRows),], Rowv=FALSE, breaks=seq(-sat,sat,length.out=22), col=palette)
suppressWarnings(
	imageHclust(t(relfluxesNeg)[rev(ordRows),], Rowv=FALSE, breaks=seq(0,-5,length.out=22), add=T, col=colorRampPalette(c('darkblue','yellow'))(21))
	)
axis(1,at=ticks, labels=c('0 min','10 min','20 min','30 min','2 h','4 h'),las=2)
abline(v=ticks[2:5], lty=2)
image(t(as.matrix(rev(varexpl_oneV[ordRows,2]))), 
	breaks=seq(0,1,length.out=21), col=colorRampPalette(c('white','black'))(20), xaxt='n', yaxt='n')
imageHclust(t(relfirings)[rev(ordRows),], Rowv=FALSE, breaks=seq(-sat,sat,length.out=22), col=palette)
axis(1,at=ticks, labels=c('0 min','10 min','20 min','30 min','2 h','4 h'),las=2)
abline(v=ticks[2:5], lty=2)
image(t(as.matrix(rev(varexpl_oneV[ordRows,3]))), 
	breaks=seq(0,1,length.out=21), col=colorRampPalette(c('white','black'))(20), xaxt='n', yaxt='n')
imageHclust(t(relelongations)[rev(ordRows),], Rowv=FALSE, breaks=seq(-sat,sat,length.out=22), col=palette)
axis(1,at=ticks, labels=c('0 min','10 min','20 min','30 min','2 h','4 h'),las=2)
abline(v=ticks[2:5], lty=2)
image(t(as.matrix(rev(varexpl_oneV[ordRows,4]))), 
	breaks=seq(0,1,length.out=21), col=colorRampPalette(c('white','black'))(20), xaxt='n', yaxt='n')
imageHclust(t(relreleases)[rev(ordRows),], Rowv=FALSE, breaks=seq(-sat,sat,length.out=22), col=palette)
axis(1,at=ticks, labels=c('0 min','10 min','20 min','30 min','2 h','4 h'),las=2)
abline(v=ticks[2:5], lty=2)

dev.off()

## color scales

pdf(file.path('figures','3C_colscale1.pdf'), height=2, width=3)
makeColscale(
	palette=palette,
	breaks=seq(-sat,sat,length.out=22)
	)
dev.off()

pdf(file.path('figures','3C_colscale2.pdf'), height=2, width=3)
makeColscale(
	palette=colorRampPalette(c('white','black'))(20),
	breaks=seq(0,1,length.out=22)
	)
dev.off()

#### figure 3E

mycShareLR <- allfeatures[names(pol2modelingclust$kmeans$cluster),
	grep('0h$',grep('mycTSSLR',colnames(allfeatures),value=T),invert=T,value=T)]
mycShareLRclusters <- sapply(
	split(data.frame(mycShareLR),pol2modelingclust$kmeans$cluster),
	function(x) mean(as.matrix(x))
	)[clIdx]
fluxRatioClusters <- log2(fluxes[nrow(fluxes),]/fluxes[1,])

pdf(file.path('figures','3E.pdf'), height=4, width=4)
par(mar=c(5,4,1,1))
symbols(x=mycShareLRclusters[ordRows], y=fluxRatioClusters[ordRows], 
	circles=sqrt(table(pol2modelingclust$kmeans$cluster)[clIdx][ordRows]), 
	inches=1/5, ann=F, bg="grey", fg='black')
text(mycShareLRclusters[ordRows], fluxRatioClusters[ordRows], seq_along(ordRows))
abline(h=0,lty=3); abline(v=0,lty=3)
dev.off()

mycBinding <- allfeatures[names(pol2modelingclust$kmeans$cluster),
	grep('mycTSS_',colnames(allfeatures),value=T)]
mycT0clusters <- sapply(split(mycBinding[,1], pol2modelingclust$kmeans$cluster), 
	mean)[clIdx]

pdf(file.path('figures','3Ebis.pdf'), height=4, width=4)
par(mar=c(5,4,1,1))
suppressWarnings(symbols(x=mycShareLRclusters[ordRows], y=mycT0clusters[ordRows], 
	circles=sqrt(table(pol2modelingclust$kmeans$cluster)[clIdx][ordRows]), 
	inches=1/5, ann=F, bg="grey", fg='black', log='y'))
title(xlab='Delta MycShare', ylab='Myc Binding at 0h')
text(mycShareLRclusters[ordRows], mycT0clusters[ordRows], seq_along(ordRows))
abline(h=0,lty=3); abline(v=0,lty=3)
dev.off()

### print numbers

inducedcl <- which(maxSynthResp[ordRows]>0)

print("variance explained from single rates:")
print(paste(paste0('p',1:4),round(colMeans(varexpl_oneV[ordRows,]),2), sep=' = '))

print("maximum fold reduction of p3 in up-regulated clusters (cl 1-4):")
print(paste(paste0('cl ',inducedcl),
	round(unname(1/2^apply(relelongations[,ordRows][,inducedcl],2, function(x) x[which.max(abs(x))])),2)
	, sep=' = '))

pseudogenes <- readRDS(file.path('data','pseudogenes.rds'))
print("average fold increase of pol2 at GB compared to k1 in up-regulated clusters (cl 1-4):")
print(paste(
	c('polTSS','polGB','polTES','k1'),
	round(rowMeans(sapply(inducedcl, function(i) rowMeans(t(pseudogenes[ordRows][[i]][-1,])/pseudogenes[ordRows][[i]][1,]))),2)
	, sep = " = ")[c(2,4)])







