source(file.path('primary_data_analysis','00_library_of_functions.R'))
load(file.path('data','allfeatures.rds'))
load(file.path('data','filtered.rds'))

####################
#### panel C ##########
####################

panelCfeatures <- c(
	## mycTSS
	"mycTSSLR_10min","mycTSSLR_20min","mycTSSLR_30min",	"mycTSSLR_2h","mycTSSLR_4h",
	# mature-mrna
	"maturemrnaLR_10min","maturemrnaLR_20min","maturemrnaLR_30min","maturemrnaLR_1h","maturemrnaLR_1.5h","maturemrnaLR_2h","maturemrnaLR_4h","maturemrnaLR_8h","maturemrnaLR_12h","maturemrnaLR_16h",
	# premrna
	"premrnaLR_10min","premrnaLR_20min","premrnaLR_30min","premrnaLR_1h","premrnaLR_1.5h","premrnaLR_2h","premrnaLR_4h","premrnaLR_8h","premrnaLR_12h","premrnaLR_16h",
	# synthesis
	"synthesisLR_10min","synthesisLR_20min","synthesisLR_30min","synthesisLR_1h","synthesisLR_1.5h","synthesisLR_2h","synthesisLR_4h","synthesisLR_8h","synthesisLR_12h","synthesisLR_16h",
	# processing
	"processingLR_10min","processingLR_20min","processingLR_30min","processingLR_1h","processingLR_1.5h","processingLR_2h","processingLR_4h","processingLR_8h","processingLR_12h","processingLR_16h",
	# degradation
	"degradationLR_10min","degradationLR_20min","degradationLR_30min","degradationLR_1h","degradationLR_1.5h","degradationLR_2h","degradationLR_4h","degradationLR_8h","degradationLR_12h","degradationLR_16h"
	)
allfeatures2C <- allfeatures[filtered,panelCfeatures]

pdf(file.path('figures','2C.pdf'), height=12, width=8)
imageHclust(allfeatures2C,
	breaks=seq(-log2(1.5),log2(1.5),length.out=22),
	colsep=makeBreaks(unique(panelCfeatures)), sepwidth=3)
dev.off()

pdf(file.path('figures','2C_colscale.pdf'), height=2, width=3)
makeColscale(
	palette=colorRampPalette(c('darkblue','blue','beige',
		'white','beige','red','darkred'))(21),
	breaks=seq(-log2(1.5),log2(1.5),length.out=22)
	)
dev.off()

####################
###### panel D #########
####################

panelDfeatures <- c(
	# mature-mrna
	"maturemrnaLR_10min","maturemrnaLR_20min","maturemrnaLR_30min","maturemrnaLR_1h","maturemrnaLR_1.5h","maturemrnaLR_2h","maturemrnaLR_4h","maturemrnaLR_8h","maturemrnaLR_12h","maturemrnaLR_16h",
	# premrna
	"premrnaLR_10min","premrnaLR_20min","premrnaLR_30min","premrnaLR_1h","premrnaLR_1.5h","premrnaLR_2h","premrnaLR_4h","premrnaLR_8h","premrnaLR_12h","premrnaLR_16h",
	# synthesis
	"synthesisLR_10min","synthesisLR_20min","synthesisLR_30min","synthesisLR_1h","synthesisLR_1.5h","synthesisLR_2h","synthesisLR_4h","synthesisLR_8h","synthesisLR_12h","synthesisLR_16h",
	# processing
	"processingLR_10min","processingLR_20min","processingLR_30min","processingLR_1h","processingLR_1.5h","processingLR_2h","processingLR_4h","processingLR_8h","processingLR_12h","processingLR_16h",
	# degradation
	"degradationLR_10min","degradationLR_20min","degradationLR_30min","degradationLR_1h","degradationLR_1.5h","degradationLR_2h","degradationLR_4h","degradationLR_8h","degradationLR_12h","degradationLR_16h"
	)
allfeatures2D <- allfeatures[filtered,panelDfeatures]
pca <- prcomp(allfeatures2D, center=FALSE, scale.=FALSE)
var_expl <- paste0(round(pca$sdev^2/sum(pca$sdev^2)*100),'%')

pdf(file.path('figures','2D.pdf'), height=5, width=5)

plot(pca$rotation[,c(1,2)], pch='',
	xlab=paste('PC1 (',var_expl[1],')'),
	ylab=paste('PC2 (',var_expl[2],')'))

startpalette <- c('blue','cyan','green','orange','red')
endpalette <- c('darkblue','darkcyan','darkgreen','darkorange3','darkred')
labels <- sub('LR$','',unique(sapply(strsplit(panelDfeatures,'_'),'[[',1)))

cols <- colorRampPalette(c(startpalette[1],endpalette[1]))(11)[-1]
tmp <- rbind(c(0,0),pca$rotation[1:10,c(1,2)])
for( i in 1:10 ) lines(tmp[i:(i+1),], pch='', col=cols[i], lwd=3)

cols<-colorRampPalette(c(startpalette[2],endpalette[2]))(11)[-1]
tmp <- rbind(c(0,0),pca$rotation[11:20,c(1,2)])
for( i in 1:10 ) lines(tmp[i:(i+1),], pch='', col=cols[i], lwd=3)

cols<-colorRampPalette(c(startpalette[3],endpalette[3]))(11)[-1]
tmp <- rbind(c(0,0),pca$rotation[21:30,c(1,2)])
for( i in 1:10 ) lines(tmp[i:(i+1),], pch='', col=cols[i], lwd=3)

cols<-colorRampPalette(c(startpalette[4],endpalette[4]))(11)[-1]
tmp <- rbind(c(0,0),pca$rotation[31:40,c(1,2)])
for( i in 1:10 ) lines(tmp[i:(i+1),], pch='', col=cols[i], lwd=3)

cols<-colorRampPalette(c(startpalette[5],endpalette[5]))(11)[-1]
tmp <- rbind(c(0,0),pca$rotation[41:50,c(1,2)])
for( i in 1:10 ) lines(tmp[i:(i+1),], pch='', col=cols[i], lwd=3)

abline(h=0, lty=2)
abline(v=0, lty=2)

legendlabels <- c('maturemrna','premrna','synthesis','processing','degradation')
ord <- sapply(labels, function(x) which(x==legendlabels))
legendlabels[legendlabels=='maturemrna'] <- 'mature'

legend('bottom',col=startpalette[ord],
	legend=legendlabels,
	lty=1, lwd=3, bty='n')

dev.off()

####################
###### panel E #########
####################

mycFC <- allfeatures[filtered,"mycTSSLR_4h"]
rnaFC <- allfeatures[filtered,"synthesisLR_4h"]

pdf(file.path('figures','2E.pdf'))

smoothXYlims(mycFC, rnaFC, xlab='myc Log2 ratio', ylab='rna Log2 ratio', 
	xlim=quantile(mycFC, c(.005,.995)), ylim=quantile(rnaFC, c(.005,.995)))

plotLoess( mycFC[rnaFC>0], rnaFC[rnaFC>0] , col='red', lwd=3)
plotLoess( mycFC[rnaFC<0], rnaFC[rnaFC<0] , col='blue', lwd=3)
plotLoess( mycFC, rnaFC , col='darkgoldenrod2', lwd=3)

abline(h=0, lty=2)
abline(v=0, lty=2)
legend('topleft', legend = c(
	paste('induced =',round(cor(mycFC[rnaFC>0], rnaFC[rnaFC>0],method='s'),2)),
	paste('repressed =',round(cor(mycFC[rnaFC<0], rnaFC[rnaFC<0],method='s'),2)),
	paste('all =',round(cor(mycFC, rnaFC, method='s'),2))
	), cex=1.1, bty='n', text.col = c('red','blue','darkgoldenrod2'))

dev.off()

