source(file.path('primary_data_analysis','00_library_of_functions.R'))

load(file.path('data','allsysRNA.RData'))
load(file.path('data','allMycChIP.RData'))

tags <- c('MycER','Waltz2014','p493','EuMyc','TetMyc')
mains <- c('3T9MycER','U2OSTet-Myc','p493-6','Eu-myc','LiverTet-Myc')

#################
##### panel A #########
#################

print('panel A')

## all genes
mycShareData <- lapply(tags, function(tag) {
	rnaseq <- allsysRNA[[tag]]
	chipseq <- subset(allMycChIP[[tag]]$tss, nchar(allMycChIP[[tag]]$tss$bound)>0)
	share_data <- merge(rnaseq, chipseq, by='EntrezID', suffixes = c('_RNA','_ChIP'))
	share_data <- na.omit(share_data)
	})
names(mycShareData) <- tags

pdf(file.path('figures','1A.pdf'), height=9, width=6)
par(mfrow=c(3,2))
for(i in seq_along(tags)) {

	tag <- tags[i]
	print(tag)

	share_data <- mycShareData[[tag]]

	mycFC <- share_data$log2ratio_ChIP
	rnaFC <- share_data$log2ratio_RNA
	shareline <- share_data$zeroshare[1]

	smoothXYlims(mycFC, rnaFC, xlab='myc Log2 ratio', ylab='rna Log2 ratio', 
		xlim=quantile(mycFC, c(.005,.995)), ylim=quantile(rnaFC, c(.005,.995)), main=mains[i])

	plotLoess( mycFC[rnaFC>0], rnaFC[rnaFC>0] , col='red', lwd=3)
	plotLoess( mycFC[rnaFC<0], rnaFC[rnaFC<0] , col='blue', lwd=3)
	plotLoess( mycFC, rnaFC , col='darkgoldenrod2', lwd=3)

	print(paste('up, cor-p-value = ', signif(suppressWarnings(cor.test(mycFC[rnaFC>0], rnaFC[rnaFC>0],method='s'))$p.value,2)))
	print(paste('down, cor-p-value = ', signif(suppressWarnings(cor.test(mycFC[rnaFC<0], rnaFC[rnaFC<0],method='s'))$p.value,2)))
	print(paste('all, cor-p-value = ', signif(suppressWarnings(cor.test(mycFC, rnaFC, method='s'))$p.value,2)))


	abline(h=0, lty=2)
	abline(v=shareline, lty=2)
	legend('topleft', legend = c(
		paste('induced =',round(cor(mycFC[rnaFC>0], rnaFC[rnaFC>0],method='s'),2)),
		paste('repressed =',round(cor(mycFC[rnaFC<0], rnaFC[rnaFC<0],method='s'),2)),
		paste('all =',round(cor(mycFC, rnaFC, method='s'),2))
		), cex=1.1, bty='n', text.col = c('red','blue','darkgoldenrod2'))
}
dev.off()

#################
## panel C ########
#################

print('panel C')

## differentially expressed genes
mycShareData <- lapply(mycShareData, function(share_data) {
	filt <- share_data$qvalue<=.1
	na.omit(share_data[filt,])
	})
names(mycShareData) <- tags

library(pROC)

pdf(file.path('figures','1C.pdf'), height=5, width=5)

i <- 1
tag <- tags[i]

share_data <- mycShareData[[tag]]
mycFC <- share_data$log2ratio_ChIP
rnaFC <- share_data$log2ratio_RNA
shareline <- share_data$zeroshare[1]

rocCurve <- roc(rnaFC>0, mycFC)
AUCs <- numeric(length(tags))
AUCs[i] <- as.numeric(rocCurve$auc)

plot(rocCurve)
idx <- which.max(rocCurve$thresholds>shareline)
points(rocCurve$specificities[idx], rocCurve$sensitivities[idx], pch=20, cex=1.5)

for(i in seq_along(tags)[-1]) {

	tag <- tags[i]

	share_data <- mycShareData[[tag]]
	mycFC <- share_data$log2ratio_ChIP
	rnaFC <- share_data$log2ratio_RNA
	shareline <- share_data$zeroshare[1]

	rocCurve <- roc(rnaFC>0, mycFC)
	AUCs[i] <- as.numeric(rocCurve$auc)

	lines(rocCurve, col=i)
	if( rocCurve$thresholds[1] == (-Inf) ) idx <- which.max(rocCurve$thresholds>shareline)
	if( rocCurve$thresholds[1] == (Inf) ) idx <- which.max(rocCurve$thresholds<shareline)
	points(rocCurve$specificities[idx], rocCurve$sensitivities[idx], pch=20, col=i, cex=1.5)

}

legend('bottomright', legend=paste(mains, '( AUC =', round(AUCs,2), ')'), 
	col=seq_along(tags), lty=1, bty='n')

dev.off()


