% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrmosaic.R
\name{distance_weighted_man_u}
\alias{distance_weighted_man_u}
\title{Distance weighted Mann-Whitney U Test}
\usage{
distance_weighted_man_u(indices, column = "", cases = data.frame(),
  background = data.frame())
}
\arguments{
\item{indices}{indices at which to compute the test}

\item{column}{index or name of column on which to compute the test}

\item{cases}{data.frame containing data for for case to be tested for deviations from background}

\item{background}{data.frame containing sample of the background distribution (e.g. data points on other chromosome/samples)}
}
\value{
Vector with one-sided p-values of distance w
}
\description{
This function computes a Mann-Whitney U Test at each of the provided indices. The data is weighed based on
the genomic distance to the index to be tested (points closer to the position under investigation have higher weights).
Weighing is done based on the tricube distance (similar to loess local regression methods). Data points at distances higher than 0.5 Mb are considered considered to have a weight = 0.
The Mann-Whitney test is then performed using weighted resampling strategy.
}

