#! /usr/bin/Rscript --vanilla --default-packages=utils
args<-commandArgs(TRUE)
library(sqldf)

direc <- "/data/ohler/Neel/metLab/data/labeling/ssj/"
setwd(direc)

u <- read.table(args[1])
d <- read.table(args[2])
name <- args[3]

#u <- read.table("preLab7_A_upstreamExon.bed")
#d <- read.table("preLab7_A_downstreamExon.bed")


upExPos <- sqldf('select max(V11), V7, V8, V9, V4, V11, V12  from u group by V4')[,-1]
upExPos <- subset(upExPos, V7 != ".")
downExPos <- sqldf('select max(V11), V7, V8, V9, V4, V11, V12  from d group by V4')[,-1]
downExPos <- subset(downExPos, V7 != ".")

write.table(upExPos,file = paste(name,"upEx.bed",sep="_"), sep = "\t", quote = F, row.names = F, col.names = F)
write.table(downExPos,file = paste(name,"downEx.bed",sep="_"), sep = "\t", quote = F, row.names = F, col.names = F)
