def write_pixelmap(pixelmap, outfile):
    """
    Write a pixelmap to a bin bedfile.

    Parameters
    ----------
    pixelmap : Dict[str, List[Dict[str, Any]]]
        The pixelmap to write. See ``lib5c.parsers.primers.get_pixelmap()``.
    outfile : str
        String reference to the file to write to.
    """
    try:
        # if we have lib5c.core we can just construct a LocusMap
        from lib5c.core.loci import LocusMap
        lm = LocusMap.from_list_of_dict([pixelmap[region][i]
                                         for region in pixelmap.keys()
                                         for i in range(len(pixelmap[region]))])
        lm.to_bedfile(outfile)
    except ImportError:
        # fallback writer
        with open(outfile, 'w') as handle:
            for region in pixelmap.keys():
                for i in range(len(pixelmap[region])):
                    handle.write('%s\t%i\t%i\t%s\n'
                                 % (pixelmap[region][i]['chrom'],
                                    pixelmap[region][i]['start'],
                                    pixelmap[region][i]['end'],
                                    pixelmap[region][i]['name']))
