def reshape_clusters_for_tetris_plotting(clusters):
    """
    Flattens clusters from list of lists of dicts to a list of dicts for each
    region and category.

    Parameters
    ----------
    clusters_superdict : Dict[str,Dict[str,List[List[Dict[str,int]]]]]
        The outer keys are the category names, the second innermost keys
        are the region names, and the values are lists of lists of
        dicts containing:

            {
             'x': int
             'y': int
             'value' : int
            }

    Returns
    -------
    Dict[str,Dict[str,List[Dict[str,int]]]]
        The outer keys are the category names, the second innermost keys
        are the region names, and the values are lists of dicts

    """
    reshaped_clusters = {category: {region: [] for region in
                        clusters[category].keys()} for category in clusters.keys()}

    for category in clusters.keys():
        for region in clusters[category].keys():
            for i in range(len(clusters[category][region])):
                if len(clusters[category][region][i])<1:
                    continue
                else:
                    reshaped_clusters[category][region].append(clusters[category][region][i])
            reshaped_clusters[category][region]=sum(reshaped_clusters[category][region],[])

    return reshaped_clusters
