import numpy as np


def reshape_2i_loops_into_matrices(loops_dict, pixelmap):
    """
     Reshapes loops dict structure from ```classify_2i_interaction_scores```
     into a dict of np.arrays

    Parameters
    ----------
    loops_dict : Dict[str,List[str]]
        The loops dict to be reshaped. The keys are the category names and
        values are lists containing information about the categorized
        primer-primer pair.
    pixelmap : Dict[str, List[Dict[str, any]]]
        The pixelmap describing the bins referred to by the ``loops_dict``.

    Returns
    --------
    Dict[str,np.ndarray]
        The dict structure to be used for the enrichment code. The keys are the
        region names, and the values are ``np.ndarray``s containing string
        representations of the category for each x,y bin.
    """
    reshaped_loops = {region: np.zeros([len(pixelmap[region]),
                                        len(pixelmap[region])], dtype='a25')
                      for region in pixelmap.keys()}
    for category in loops_dict.keys():
        for loop in loops_dict[category]:
            region = str(loop[0]).split('_')[0]
            bin_x = int(str(loop[0]).split('_')[2])
            bin_y = int(str(loop[1]).split('_')[2])
            reshaped_loops[region][bin_x, bin_y] = str(category)
            reshaped_loops[region][bin_y, bin_x] = str(category)

    return reshaped_loops
