import numpy as np

def reshape_2i_loops_for_clustering(loops_dict,region_list):
    """
     Reshapes loops dict structure into a triple-nested superdict structure
     in order to run the old clustering code from lib5c.

    Parameters
    ----------
    loops_dict : Dict[str,List[str]]
        The loops dict to be reshaped. The keys are the category names and
        values are lists containing information about the categorized
        primer-primer pair.
    region_list : List[str]
        A list of region names. 

    Returns
    --------
    Dict[str,Dict[str,List[List[Dict[str,int]]]
        The supderdict structure to be used for the clustering code. The outermost keys are the category name,
        the inner keys are the region name, and the values are lists of lists of dicts containing x and y labels 
        as the keys with the bin indices as the values for the specified region and category.
    """

    reshaped_loops = {category:{region:[] for region in region_list} for
                      category in loops_dict.keys()}
    for category in loops_dict.keys():
        for loop in loops_dict[category]:
            region =     loop[0].split('_')[0]
            bin_x  = int(loop[0].split('_')[2])
            bin_y  = int(loop[1].split('_')[2])
            reshaped_loops[category][region].append({'x': bin_x, 'y': bin_y,'value':0})
            
    return reshaped_loops

