import numpy as np
from make_expected_matrix_from_list import make_expected_matrix_from_list

def make_expected_matrix_binned(obs_matrix,exp_model,
                                is_global=True,**kwargs):
    """
    Convenience function for quickly making an expected matrix for a
    bin-level observed counts matrix.

    Parameters
    ----------
    obs_matrix : Dict[str,np.nadarray] or np.ndarray
        The dict or matrix of observed counts.
    exp_model : Callable[List[float]]
        a function that generates an expected model from binned data
    is_global : bool
        sets the scale of the expected model. If False, the regional
        expected model will be determined. 

    Returns
    -------
    Dict[str, np.ndarray] or np.ndarray
        The expected dict or matrix.
    """
    if isinstance(obs_matrix,dict) and not is_global:
        #returns regional expected dict if an observed counts dict is passed and is_global == False
        expected_model = {region : exp_model(obs_matrix[region],is_global=False,**kwargs) 
                          for region in obs_matrix.keys()}
        return {region : make_expected_matrix_from_list(expected_model[region]) for region in obs_matrix.keys()}

    elif isinstance(obs_matrix,np.ndarray) or (isinstance(obs_matrix,dict) and is_global):
        #returns regional expected matrix if single observed counts matrix is passed
        #or global expected dict if observed counts dict is passed and is_global == True
        expected_model = exp_model(obs_matrix,is_global=is_global,**kwargs)
        if not is_global:
            return make_expected_matrix_from_list(expected_model)
        else:
            return {region : make_expected_matrix_from_list(expected_model)[0:len(obs_matrix[region]),0:len(obs_matrix[region])] for region in obs_matrix.keys()}
    else:
        print('Cannot calculate expected matrix. Make sure you are using the proper expected model for your counts data structure.')
