from get_mid_to_mid_distance import get_mid_to_mid_distance

def make_compiled_list_for_2i_thresholding(counts_list,pixelmap,distance_span = 'start-to-start'):
    """
    Compiles lists of interaction scores across replicates for each bin-bin
    pair.

    Parameters
    ----------
    counts_list : List[Dict[str,np.ndarray]]
        A list of counts dicts where the region names are the keys and the
        values are counts matrices.
    pixelmap : Dict[str,List[Dict[str, Any]]]
        The keys are region names and the values are ordered lists of bins
        tiling a given region. The elements of the list are dicts (representing
        bins) with the following structure::

            {
             'name': str,
             'chrom': str,
             'start': int,
             'end': int,
             'index': int,
             'region': str
            }

    distance_span = str
        Specifies how genomic distance between two interacting bins will be
        determined.

    Returns
    -------
    List[List[str]]
    A compiled list containing all interaction scores for all bin-bin pairs. 
    """
    compiled_list = []
    for region in counts_list[0].keys():
        for i in range(len(pixelmap[region])):
            for j in range(i + 1):
                bin1_ID = pixelmap[region][i]['name']
                bin2_ID = pixelmap[region][j]['name']
                if distance_span == 'start-to-end':
                    distance = abs(pixelmap[region][j]['start'] - pixelmap[region][i]['end'])
                    pass
                elif distance_span == 'start-to-start':
                    distance = abs(pixelmap[region][j]['start'] - pixelmap[region][i]['start'])
                    pass
                elif distance_span == 'end-to-end':
                    distance = abs(pixelmap[region][j]['end'] - pixelmap[region][i]['end'])
                    pass
                elif distance_span == 'mid-to-mid':
                    distance = get_mid_to_mid_distance(
                        {'start': pixelmap[region][j]['start'], 'end': pixelmap[region][j]['end']},
                        {'start': pixelmap[region][i]['start'], 'end': pixelmap[region][i]['end']})
                    pass
                ES1_value = counts_list[0][region][i,j]
                ES2_value = counts_list[1][region][i,j]
                pNPC1_value = counts_list[2][region][i,j]
                pNPC2_value = counts_list[3][region][i,j]
                ES2i1_value = counts_list[4][region][i,j]
                ES2i2_value = counts_list[5][region][i,j]

                compiled_list.append([region, bin1_ID, bin2_ID, distance, ES1_value,
                                      ES2_value,pNPC1_value,pNPC2_value,ES2i1_value,ES2i2_value])
    return compiled_list


                    


