library(MASS)
library(ggplot2)

args <- commandArgs(trailingOnly = TRUE)

files <- Sys.glob(args)

for (i in 1:length(files)){
  file=data.frame(read.table(files[i]))
  regions=as.matrix(gsub("_.*$","",file$V1))
  d=cbind(regions,file[3])
  region=levels(d$regions)
  rep_trim1=gsub(".counts*$",'',files[i])

  for (j in 1:length(region)){
    total_region<-d$V3[grep(region[j],d$regions)]
    total_region_model<-total_region[!is.na(total_region)]
    a=fitdistr(total_region_model, "logistic")#>0

    min=min(total_region_model)
    max=max(total_region_model)
    x <- seq(min,max,length=100)
    x1<-dlogis(x, location = as.numeric(a$estimate[1]), scale =as.numeric(a$estimate[2]))
    
    total_region_hist<-hist(total_region,breaks=50,plot=FALSE)

    name=sprintf("logistic_fit_%s.jpg", rep_trim1)
    
    jpeg(filename=name, width=5, height=5, units="in", res=500)
    hist(total_region,lty=0,prob=TRUE, xlab='',ylab='',xlim=c(-(max),max),ylim=c(0,max),main='')
    lines(total_region_hist$breaks,c(total_region_hist$density,0),type="s",col=i+1,lwd=1.5)
    
    curve(dlogis(x, location = as.numeric(a$estimate[1]), scale =as.numeric(a$estimate[2])),lwd=2,add=T)
    reps_and_curve=c(rep_trim1,'logistic curve')
    legend("topright", reps_and_curve, fill=c(i+1,1),cex=0.5)
    dev.off()
  }
}
