import numpy as np

from compute_obs_over_exp_mean_variance import\
    compute_obs_over_exp_mean_variance
from function_util import parallelize_regions

@parallelize_regions
def learn_mvr_from_obs_over_exp(obs_over_exp, log=False):
    mean, variance = compute_obs_over_exp_mean_variance(
                        obs_matrix, exp_matrix, log=log)
    if log:
        return lambda mu: (np.log(mu) + mean, variance)
    else:
        return lambda mu: (mu * mean, variance * mu ** 2)
