def hsu_primer_name_parser(name):
    """
    The double alternating primer name parser.

    Parameters
    ---------
    name : str
        The name of the primer found in the appropriate column of the primer
        bedfile.

    Returns
    -------
    dict
        This dict has the following structure::

            {
                'region': str,
                'number': int,
                'name': str
            }

        These fields are parsed from the primer name.

    Notes
    -----
    You can write other name parsers to accommodate different primer naming
    conventions.
    """
    pieces = name.split('_')
    region = pieces[4].split(':')[0].split('|')[2]
    number = int(pieces[4].split(':')[0].split('|')[0])
    orientation = "3'" if pieces[3].split('-')[0] in ['FOR', 'LFOR'] else "5'"
    corrected_name = name.split(':')[0]+':'+name.split(':')[1]

    return {'region': region,
            'number': number,
            'orientation': orientation,
            'name'  : corrected_name}
