
def get_midpoint(fragment):
    """
    Gets the midpoint of a fragment.

    Parameters
    ----------
    fragment : Dict[str, Any]
        The fragment to find the midpoint of. The fragment must be represented
        as a dict with at least the following keys::

            {
                'start': int,
                'end': int
            }

    Returns
    -------
    int
        The midpoint of the fragment, rounded towards zero if necessary.

    Examples
    --------
    >>> fragment = {'start': 50, 'end': 100}
    >>> get_midpoint(fragment)
    75
    """
    return (fragment['start'] + fragment['end']) / 2
