from get_annotation_percentage_all import get_annotation_percentage_all

def get_fold_change_all(annotation_a, annotation_b, category, annotationmaps, looping_classes):
      
    """
    Returns a ratio comparing the percentage of times annotation_a and annotation_b are both found in a given 
    category of loop types to the percentage of times annotation_a and annotation_b are both found in the 'background'
    category of loops (see function load_loops()) in all genomic regions loaded into the function get_pixelmap . 
    (see function: get_pixelmap())
    
    Parameters
    ----------
    annotation_a: String reference to annotation to use
    annotation_b: String reference to second annotation to use
    category: string reference to type of loop (see load_loops())
    
    """
    
    
    if  get_percentage_all(annotation_a, annotation_b, 'background')==0:
        return 0
    return get_percentage_percentage_all(annotation_a, annotation_b, category, annotationmaps, looping_classes) / get_annotation_percentage_all(annotation_a, annotation_b, 'background', annotationmaps, looping_classes)

